/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ecs.model.TaskSetField;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class DescribeTaskSetsRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String cluster;
    private String service;
    private SdkInternalList<String> taskSets;
    private SdkInternalList<String> include;

    public void setCluster(String cluster) {
        this.cluster = cluster;
    }

    public String getCluster() {
        return this.cluster;
    }

    public DescribeTaskSetsRequest withCluster(String cluster) {
        this.setCluster(cluster);
        return this;
    }

    public void setService(String service) {
        this.service = service;
    }

    public String getService() {
        return this.service;
    }

    public DescribeTaskSetsRequest withService(String service) {
        this.setService(service);
        return this;
    }

    public List<String> getTaskSets() {
        if (this.taskSets == null) {
            this.taskSets = new SdkInternalList();
        }
        return this.taskSets;
    }

    public void setTaskSets(Collection<String> taskSets) {
        if (taskSets == null) {
            this.taskSets = null;
            return;
        }
        this.taskSets = new SdkInternalList(taskSets);
    }

    public DescribeTaskSetsRequest withTaskSets(String ... taskSets) {
        if (this.taskSets == null) {
            this.setTaskSets((Collection<String>)new SdkInternalList(taskSets.length));
        }
        for (String ele : taskSets) {
            this.taskSets.add((Object)ele);
        }
        return this;
    }

    public DescribeTaskSetsRequest withTaskSets(Collection<String> taskSets) {
        this.setTaskSets(taskSets);
        return this;
    }

    public List<String> getInclude() {
        if (this.include == null) {
            this.include = new SdkInternalList();
        }
        return this.include;
    }

    public void setInclude(Collection<String> include) {
        if (include == null) {
            this.include = null;
            return;
        }
        this.include = new SdkInternalList(include);
    }

    public DescribeTaskSetsRequest withInclude(String ... include) {
        if (this.include == null) {
            this.setInclude((Collection<String>)new SdkInternalList(include.length));
        }
        for (String ele : include) {
            this.include.add((Object)ele);
        }
        return this;
    }

    public DescribeTaskSetsRequest withInclude(Collection<String> include) {
        this.setInclude(include);
        return this;
    }

    public DescribeTaskSetsRequest withInclude(TaskSetField ... include) {
        SdkInternalList includeCopy = new SdkInternalList(include.length);
        for (TaskSetField value : include) {
            includeCopy.add((Object)value.toString());
        }
        if (this.getInclude() == null) {
            this.setInclude((Collection<String>)includeCopy);
        } else {
            this.getInclude().addAll((Collection<String>)includeCopy);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCluster() != null) {
            sb.append("Cluster: ").append(this.getCluster()).append(",");
        }
        if (this.getService() != null) {
            sb.append("Service: ").append(this.getService()).append(",");
        }
        if (this.getTaskSets() != null) {
            sb.append("TaskSets: ").append(this.getTaskSets()).append(",");
        }
        if (this.getInclude() != null) {
            sb.append("Include: ").append(this.getInclude());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTaskSetsRequest)) {
            return false;
        }
        DescribeTaskSetsRequest other = (DescribeTaskSetsRequest)obj;
        if (other.getCluster() == null ^ this.getCluster() == null) {
            return false;
        }
        if (other.getCluster() != null && !other.getCluster().equals(this.getCluster())) {
            return false;
        }
        if (other.getService() == null ^ this.getService() == null) {
            return false;
        }
        if (other.getService() != null && !other.getService().equals(this.getService())) {
            return false;
        }
        if (other.getTaskSets() == null ^ this.getTaskSets() == null) {
            return false;
        }
        if (other.getTaskSets() != null && !other.getTaskSets().equals(this.getTaskSets())) {
            return false;
        }
        if (other.getInclude() == null ^ this.getInclude() == null) {
            return false;
        }
        return other.getInclude() == null || other.getInclude().equals(this.getInclude());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCluster() == null ? 0 : this.getCluster().hashCode());
        hashCode = 31 * hashCode + (this.getService() == null ? 0 : this.getService().hashCode());
        hashCode = 31 * hashCode + (this.getTaskSets() == null ? 0 : this.getTaskSets().hashCode());
        hashCode = 31 * hashCode + (this.getInclude() == null ? 0 : this.getInclude().hashCode());
        return hashCode;
    }

    public DescribeTaskSetsRequest clone() {
        return (DescribeTaskSetsRequest)super.clone();
    }
}

