/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ecs.model.HostEntry;
import com.amazonaws.services.ecs.model.KeyValuePair;
import com.amazonaws.services.ecs.model.LogConfiguration;
import com.amazonaws.services.ecs.model.MountPoint;
import com.amazonaws.services.ecs.model.PortMapping;
import com.amazonaws.services.ecs.model.Ulimit;
import com.amazonaws.services.ecs.model.VolumeFrom;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ContainerDefinition
implements Serializable,
Cloneable {
    private String name;
    private String image;
    private Integer cpu;
    private Integer memory;
    private Integer memoryReservation;
    private SdkInternalList<String> links;
    private SdkInternalList<PortMapping> portMappings;
    private Boolean essential;
    private SdkInternalList<String> entryPoint;
    private SdkInternalList<String> command;
    private SdkInternalList<KeyValuePair> environment;
    private SdkInternalList<MountPoint> mountPoints;
    private SdkInternalList<VolumeFrom> volumesFrom;
    private String hostname;
    private String user;
    private String workingDirectory;
    private Boolean disableNetworking;
    private Boolean privileged;
    private Boolean readonlyRootFilesystem;
    private SdkInternalList<String> dnsServers;
    private SdkInternalList<String> dnsSearchDomains;
    private SdkInternalList<HostEntry> extraHosts;
    private SdkInternalList<String> dockerSecurityOptions;
    private Map<String, String> dockerLabels;
    private SdkInternalList<Ulimit> ulimits;
    private LogConfiguration logConfiguration;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public ContainerDefinition withName(String name) {
        this.setName(name);
        return this;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public String getImage() {
        return this.image;
    }

    public ContainerDefinition withImage(String image) {
        this.setImage(image);
        return this;
    }

    public void setCpu(Integer cpu) {
        this.cpu = cpu;
    }

    public Integer getCpu() {
        return this.cpu;
    }

    public ContainerDefinition withCpu(Integer cpu) {
        this.setCpu(cpu);
        return this;
    }

    public void setMemory(Integer memory) {
        this.memory = memory;
    }

    public Integer getMemory() {
        return this.memory;
    }

    public ContainerDefinition withMemory(Integer memory) {
        this.setMemory(memory);
        return this;
    }

    public void setMemoryReservation(Integer memoryReservation) {
        this.memoryReservation = memoryReservation;
    }

    public Integer getMemoryReservation() {
        return this.memoryReservation;
    }

    public ContainerDefinition withMemoryReservation(Integer memoryReservation) {
        this.setMemoryReservation(memoryReservation);
        return this;
    }

    public List<String> getLinks() {
        if (this.links == null) {
            this.links = new SdkInternalList();
        }
        return this.links;
    }

    public void setLinks(Collection<String> links) {
        if (links == null) {
            this.links = null;
            return;
        }
        this.links = new SdkInternalList(links);
    }

    public ContainerDefinition withLinks(String ... links) {
        if (this.links == null) {
            this.setLinks((Collection<String>)new SdkInternalList(links.length));
        }
        for (String ele : links) {
            this.links.add((Object)ele);
        }
        return this;
    }

    public ContainerDefinition withLinks(Collection<String> links) {
        this.setLinks(links);
        return this;
    }

    public List<PortMapping> getPortMappings() {
        if (this.portMappings == null) {
            this.portMappings = new SdkInternalList();
        }
        return this.portMappings;
    }

    public void setPortMappings(Collection<PortMapping> portMappings) {
        if (portMappings == null) {
            this.portMappings = null;
            return;
        }
        this.portMappings = new SdkInternalList(portMappings);
    }

    public ContainerDefinition withPortMappings(PortMapping ... portMappings) {
        if (this.portMappings == null) {
            this.setPortMappings((Collection<PortMapping>)new SdkInternalList(portMappings.length));
        }
        for (PortMapping ele : portMappings) {
            this.portMappings.add((Object)ele);
        }
        return this;
    }

    public ContainerDefinition withPortMappings(Collection<PortMapping> portMappings) {
        this.setPortMappings(portMappings);
        return this;
    }

    public void setEssential(Boolean essential) {
        this.essential = essential;
    }

    public Boolean getEssential() {
        return this.essential;
    }

    public ContainerDefinition withEssential(Boolean essential) {
        this.setEssential(essential);
        return this;
    }

    public Boolean isEssential() {
        return this.essential;
    }

    public List<String> getEntryPoint() {
        if (this.entryPoint == null) {
            this.entryPoint = new SdkInternalList();
        }
        return this.entryPoint;
    }

    public void setEntryPoint(Collection<String> entryPoint) {
        if (entryPoint == null) {
            this.entryPoint = null;
            return;
        }
        this.entryPoint = new SdkInternalList(entryPoint);
    }

    public ContainerDefinition withEntryPoint(String ... entryPoint) {
        if (this.entryPoint == null) {
            this.setEntryPoint((Collection<String>)new SdkInternalList(entryPoint.length));
        }
        for (String ele : entryPoint) {
            this.entryPoint.add((Object)ele);
        }
        return this;
    }

    public ContainerDefinition withEntryPoint(Collection<String> entryPoint) {
        this.setEntryPoint(entryPoint);
        return this;
    }

    public List<String> getCommand() {
        if (this.command == null) {
            this.command = new SdkInternalList();
        }
        return this.command;
    }

    public void setCommand(Collection<String> command) {
        if (command == null) {
            this.command = null;
            return;
        }
        this.command = new SdkInternalList(command);
    }

    public ContainerDefinition withCommand(String ... command) {
        if (this.command == null) {
            this.setCommand((Collection<String>)new SdkInternalList(command.length));
        }
        for (String ele : command) {
            this.command.add((Object)ele);
        }
        return this;
    }

    public ContainerDefinition withCommand(Collection<String> command) {
        this.setCommand(command);
        return this;
    }

    public List<KeyValuePair> getEnvironment() {
        if (this.environment == null) {
            this.environment = new SdkInternalList();
        }
        return this.environment;
    }

    public void setEnvironment(Collection<KeyValuePair> environment) {
        if (environment == null) {
            this.environment = null;
            return;
        }
        this.environment = new SdkInternalList(environment);
    }

    public ContainerDefinition withEnvironment(KeyValuePair ... environment) {
        if (this.environment == null) {
            this.setEnvironment((Collection<KeyValuePair>)new SdkInternalList(environment.length));
        }
        for (KeyValuePair ele : environment) {
            this.environment.add((Object)ele);
        }
        return this;
    }

    public ContainerDefinition withEnvironment(Collection<KeyValuePair> environment) {
        this.setEnvironment(environment);
        return this;
    }

    public List<MountPoint> getMountPoints() {
        if (this.mountPoints == null) {
            this.mountPoints = new SdkInternalList();
        }
        return this.mountPoints;
    }

    public void setMountPoints(Collection<MountPoint> mountPoints) {
        if (mountPoints == null) {
            this.mountPoints = null;
            return;
        }
        this.mountPoints = new SdkInternalList(mountPoints);
    }

    public ContainerDefinition withMountPoints(MountPoint ... mountPoints) {
        if (this.mountPoints == null) {
            this.setMountPoints((Collection<MountPoint>)new SdkInternalList(mountPoints.length));
        }
        for (MountPoint ele : mountPoints) {
            this.mountPoints.add((Object)ele);
        }
        return this;
    }

    public ContainerDefinition withMountPoints(Collection<MountPoint> mountPoints) {
        this.setMountPoints(mountPoints);
        return this;
    }

    public List<VolumeFrom> getVolumesFrom() {
        if (this.volumesFrom == null) {
            this.volumesFrom = new SdkInternalList();
        }
        return this.volumesFrom;
    }

    public void setVolumesFrom(Collection<VolumeFrom> volumesFrom) {
        if (volumesFrom == null) {
            this.volumesFrom = null;
            return;
        }
        this.volumesFrom = new SdkInternalList(volumesFrom);
    }

    public ContainerDefinition withVolumesFrom(VolumeFrom ... volumesFrom) {
        if (this.volumesFrom == null) {
            this.setVolumesFrom((Collection<VolumeFrom>)new SdkInternalList(volumesFrom.length));
        }
        for (VolumeFrom ele : volumesFrom) {
            this.volumesFrom.add((Object)ele);
        }
        return this;
    }

    public ContainerDefinition withVolumesFrom(Collection<VolumeFrom> volumesFrom) {
        this.setVolumesFrom(volumesFrom);
        return this;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public String getHostname() {
        return this.hostname;
    }

    public ContainerDefinition withHostname(String hostname) {
        this.setHostname(hostname);
        return this;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getUser() {
        return this.user;
    }

    public ContainerDefinition withUser(String user) {
        this.setUser(user);
        return this;
    }

    public void setWorkingDirectory(String workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    public String getWorkingDirectory() {
        return this.workingDirectory;
    }

    public ContainerDefinition withWorkingDirectory(String workingDirectory) {
        this.setWorkingDirectory(workingDirectory);
        return this;
    }

    public void setDisableNetworking(Boolean disableNetworking) {
        this.disableNetworking = disableNetworking;
    }

    public Boolean getDisableNetworking() {
        return this.disableNetworking;
    }

    public ContainerDefinition withDisableNetworking(Boolean disableNetworking) {
        this.setDisableNetworking(disableNetworking);
        return this;
    }

    public Boolean isDisableNetworking() {
        return this.disableNetworking;
    }

    public void setPrivileged(Boolean privileged) {
        this.privileged = privileged;
    }

    public Boolean getPrivileged() {
        return this.privileged;
    }

    public ContainerDefinition withPrivileged(Boolean privileged) {
        this.setPrivileged(privileged);
        return this;
    }

    public Boolean isPrivileged() {
        return this.privileged;
    }

    public void setReadonlyRootFilesystem(Boolean readonlyRootFilesystem) {
        this.readonlyRootFilesystem = readonlyRootFilesystem;
    }

    public Boolean getReadonlyRootFilesystem() {
        return this.readonlyRootFilesystem;
    }

    public ContainerDefinition withReadonlyRootFilesystem(Boolean readonlyRootFilesystem) {
        this.setReadonlyRootFilesystem(readonlyRootFilesystem);
        return this;
    }

    public Boolean isReadonlyRootFilesystem() {
        return this.readonlyRootFilesystem;
    }

    public List<String> getDnsServers() {
        if (this.dnsServers == null) {
            this.dnsServers = new SdkInternalList();
        }
        return this.dnsServers;
    }

    public void setDnsServers(Collection<String> dnsServers) {
        if (dnsServers == null) {
            this.dnsServers = null;
            return;
        }
        this.dnsServers = new SdkInternalList(dnsServers);
    }

    public ContainerDefinition withDnsServers(String ... dnsServers) {
        if (this.dnsServers == null) {
            this.setDnsServers((Collection<String>)new SdkInternalList(dnsServers.length));
        }
        for (String ele : dnsServers) {
            this.dnsServers.add((Object)ele);
        }
        return this;
    }

    public ContainerDefinition withDnsServers(Collection<String> dnsServers) {
        this.setDnsServers(dnsServers);
        return this;
    }

    public List<String> getDnsSearchDomains() {
        if (this.dnsSearchDomains == null) {
            this.dnsSearchDomains = new SdkInternalList();
        }
        return this.dnsSearchDomains;
    }

    public void setDnsSearchDomains(Collection<String> dnsSearchDomains) {
        if (dnsSearchDomains == null) {
            this.dnsSearchDomains = null;
            return;
        }
        this.dnsSearchDomains = new SdkInternalList(dnsSearchDomains);
    }

    public ContainerDefinition withDnsSearchDomains(String ... dnsSearchDomains) {
        if (this.dnsSearchDomains == null) {
            this.setDnsSearchDomains((Collection<String>)new SdkInternalList(dnsSearchDomains.length));
        }
        for (String ele : dnsSearchDomains) {
            this.dnsSearchDomains.add((Object)ele);
        }
        return this;
    }

    public ContainerDefinition withDnsSearchDomains(Collection<String> dnsSearchDomains) {
        this.setDnsSearchDomains(dnsSearchDomains);
        return this;
    }

    public List<HostEntry> getExtraHosts() {
        if (this.extraHosts == null) {
            this.extraHosts = new SdkInternalList();
        }
        return this.extraHosts;
    }

    public void setExtraHosts(Collection<HostEntry> extraHosts) {
        if (extraHosts == null) {
            this.extraHosts = null;
            return;
        }
        this.extraHosts = new SdkInternalList(extraHosts);
    }

    public ContainerDefinition withExtraHosts(HostEntry ... extraHosts) {
        if (this.extraHosts == null) {
            this.setExtraHosts((Collection<HostEntry>)new SdkInternalList(extraHosts.length));
        }
        for (HostEntry ele : extraHosts) {
            this.extraHosts.add((Object)ele);
        }
        return this;
    }

    public ContainerDefinition withExtraHosts(Collection<HostEntry> extraHosts) {
        this.setExtraHosts(extraHosts);
        return this;
    }

    public List<String> getDockerSecurityOptions() {
        if (this.dockerSecurityOptions == null) {
            this.dockerSecurityOptions = new SdkInternalList();
        }
        return this.dockerSecurityOptions;
    }

    public void setDockerSecurityOptions(Collection<String> dockerSecurityOptions) {
        if (dockerSecurityOptions == null) {
            this.dockerSecurityOptions = null;
            return;
        }
        this.dockerSecurityOptions = new SdkInternalList(dockerSecurityOptions);
    }

    public ContainerDefinition withDockerSecurityOptions(String ... dockerSecurityOptions) {
        if (this.dockerSecurityOptions == null) {
            this.setDockerSecurityOptions((Collection<String>)new SdkInternalList(dockerSecurityOptions.length));
        }
        for (String ele : dockerSecurityOptions) {
            this.dockerSecurityOptions.add((Object)ele);
        }
        return this;
    }

    public ContainerDefinition withDockerSecurityOptions(Collection<String> dockerSecurityOptions) {
        this.setDockerSecurityOptions(dockerSecurityOptions);
        return this;
    }

    public Map<String, String> getDockerLabels() {
        return this.dockerLabels;
    }

    public void setDockerLabels(Map<String, String> dockerLabels) {
        this.dockerLabels = dockerLabels;
    }

    public ContainerDefinition withDockerLabels(Map<String, String> dockerLabels) {
        this.setDockerLabels(dockerLabels);
        return this;
    }

    public ContainerDefinition addDockerLabelsEntry(String key, String value) {
        if (null == this.dockerLabels) {
            this.dockerLabels = new HashMap<String, String>();
        }
        if (this.dockerLabels.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.dockerLabels.put(key, value);
        return this;
    }

    public ContainerDefinition clearDockerLabelsEntries() {
        this.dockerLabels = null;
        return this;
    }

    public List<Ulimit> getUlimits() {
        if (this.ulimits == null) {
            this.ulimits = new SdkInternalList();
        }
        return this.ulimits;
    }

    public void setUlimits(Collection<Ulimit> ulimits) {
        if (ulimits == null) {
            this.ulimits = null;
            return;
        }
        this.ulimits = new SdkInternalList(ulimits);
    }

    public ContainerDefinition withUlimits(Ulimit ... ulimits) {
        if (this.ulimits == null) {
            this.setUlimits((Collection<Ulimit>)new SdkInternalList(ulimits.length));
        }
        for (Ulimit ele : ulimits) {
            this.ulimits.add((Object)ele);
        }
        return this;
    }

    public ContainerDefinition withUlimits(Collection<Ulimit> ulimits) {
        this.setUlimits(ulimits);
        return this;
    }

    public void setLogConfiguration(LogConfiguration logConfiguration) {
        this.logConfiguration = logConfiguration;
    }

    public LogConfiguration getLogConfiguration() {
        return this.logConfiguration;
    }

    public ContainerDefinition withLogConfiguration(LogConfiguration logConfiguration) {
        this.setLogConfiguration(logConfiguration);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getImage() != null) {
            sb.append("Image: ").append(this.getImage()).append(",");
        }
        if (this.getCpu() != null) {
            sb.append("Cpu: ").append(this.getCpu()).append(",");
        }
        if (this.getMemory() != null) {
            sb.append("Memory: ").append(this.getMemory()).append(",");
        }
        if (this.getMemoryReservation() != null) {
            sb.append("MemoryReservation: ").append(this.getMemoryReservation()).append(",");
        }
        if (this.getLinks() != null) {
            sb.append("Links: ").append(this.getLinks()).append(",");
        }
        if (this.getPortMappings() != null) {
            sb.append("PortMappings: ").append(this.getPortMappings()).append(",");
        }
        if (this.getEssential() != null) {
            sb.append("Essential: ").append(this.getEssential()).append(",");
        }
        if (this.getEntryPoint() != null) {
            sb.append("EntryPoint: ").append(this.getEntryPoint()).append(",");
        }
        if (this.getCommand() != null) {
            sb.append("Command: ").append(this.getCommand()).append(",");
        }
        if (this.getEnvironment() != null) {
            sb.append("Environment: ").append(this.getEnvironment()).append(",");
        }
        if (this.getMountPoints() != null) {
            sb.append("MountPoints: ").append(this.getMountPoints()).append(",");
        }
        if (this.getVolumesFrom() != null) {
            sb.append("VolumesFrom: ").append(this.getVolumesFrom()).append(",");
        }
        if (this.getHostname() != null) {
            sb.append("Hostname: ").append(this.getHostname()).append(",");
        }
        if (this.getUser() != null) {
            sb.append("User: ").append(this.getUser()).append(",");
        }
        if (this.getWorkingDirectory() != null) {
            sb.append("WorkingDirectory: ").append(this.getWorkingDirectory()).append(",");
        }
        if (this.getDisableNetworking() != null) {
            sb.append("DisableNetworking: ").append(this.getDisableNetworking()).append(",");
        }
        if (this.getPrivileged() != null) {
            sb.append("Privileged: ").append(this.getPrivileged()).append(",");
        }
        if (this.getReadonlyRootFilesystem() != null) {
            sb.append("ReadonlyRootFilesystem: ").append(this.getReadonlyRootFilesystem()).append(",");
        }
        if (this.getDnsServers() != null) {
            sb.append("DnsServers: ").append(this.getDnsServers()).append(",");
        }
        if (this.getDnsSearchDomains() != null) {
            sb.append("DnsSearchDomains: ").append(this.getDnsSearchDomains()).append(",");
        }
        if (this.getExtraHosts() != null) {
            sb.append("ExtraHosts: ").append(this.getExtraHosts()).append(",");
        }
        if (this.getDockerSecurityOptions() != null) {
            sb.append("DockerSecurityOptions: ").append(this.getDockerSecurityOptions()).append(",");
        }
        if (this.getDockerLabels() != null) {
            sb.append("DockerLabels: ").append(this.getDockerLabels()).append(",");
        }
        if (this.getUlimits() != null) {
            sb.append("Ulimits: ").append(this.getUlimits()).append(",");
        }
        if (this.getLogConfiguration() != null) {
            sb.append("LogConfiguration: ").append(this.getLogConfiguration());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContainerDefinition)) {
            return false;
        }
        ContainerDefinition other = (ContainerDefinition)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getImage() == null ^ this.getImage() == null) {
            return false;
        }
        if (other.getImage() != null && !other.getImage().equals(this.getImage())) {
            return false;
        }
        if (other.getCpu() == null ^ this.getCpu() == null) {
            return false;
        }
        if (other.getCpu() != null && !other.getCpu().equals(this.getCpu())) {
            return false;
        }
        if (other.getMemory() == null ^ this.getMemory() == null) {
            return false;
        }
        if (other.getMemory() != null && !other.getMemory().equals(this.getMemory())) {
            return false;
        }
        if (other.getMemoryReservation() == null ^ this.getMemoryReservation() == null) {
            return false;
        }
        if (other.getMemoryReservation() != null && !other.getMemoryReservation().equals(this.getMemoryReservation())) {
            return false;
        }
        if (other.getLinks() == null ^ this.getLinks() == null) {
            return false;
        }
        if (other.getLinks() != null && !other.getLinks().equals(this.getLinks())) {
            return false;
        }
        if (other.getPortMappings() == null ^ this.getPortMappings() == null) {
            return false;
        }
        if (other.getPortMappings() != null && !other.getPortMappings().equals(this.getPortMappings())) {
            return false;
        }
        if (other.getEssential() == null ^ this.getEssential() == null) {
            return false;
        }
        if (other.getEssential() != null && !other.getEssential().equals(this.getEssential())) {
            return false;
        }
        if (other.getEntryPoint() == null ^ this.getEntryPoint() == null) {
            return false;
        }
        if (other.getEntryPoint() != null && !other.getEntryPoint().equals(this.getEntryPoint())) {
            return false;
        }
        if (other.getCommand() == null ^ this.getCommand() == null) {
            return false;
        }
        if (other.getCommand() != null && !other.getCommand().equals(this.getCommand())) {
            return false;
        }
        if (other.getEnvironment() == null ^ this.getEnvironment() == null) {
            return false;
        }
        if (other.getEnvironment() != null && !other.getEnvironment().equals(this.getEnvironment())) {
            return false;
        }
        if (other.getMountPoints() == null ^ this.getMountPoints() == null) {
            return false;
        }
        if (other.getMountPoints() != null && !other.getMountPoints().equals(this.getMountPoints())) {
            return false;
        }
        if (other.getVolumesFrom() == null ^ this.getVolumesFrom() == null) {
            return false;
        }
        if (other.getVolumesFrom() != null && !other.getVolumesFrom().equals(this.getVolumesFrom())) {
            return false;
        }
        if (other.getHostname() == null ^ this.getHostname() == null) {
            return false;
        }
        if (other.getHostname() != null && !other.getHostname().equals(this.getHostname())) {
            return false;
        }
        if (other.getUser() == null ^ this.getUser() == null) {
            return false;
        }
        if (other.getUser() != null && !other.getUser().equals(this.getUser())) {
            return false;
        }
        if (other.getWorkingDirectory() == null ^ this.getWorkingDirectory() == null) {
            return false;
        }
        if (other.getWorkingDirectory() != null && !other.getWorkingDirectory().equals(this.getWorkingDirectory())) {
            return false;
        }
        if (other.getDisableNetworking() == null ^ this.getDisableNetworking() == null) {
            return false;
        }
        if (other.getDisableNetworking() != null && !other.getDisableNetworking().equals(this.getDisableNetworking())) {
            return false;
        }
        if (other.getPrivileged() == null ^ this.getPrivileged() == null) {
            return false;
        }
        if (other.getPrivileged() != null && !other.getPrivileged().equals(this.getPrivileged())) {
            return false;
        }
        if (other.getReadonlyRootFilesystem() == null ^ this.getReadonlyRootFilesystem() == null) {
            return false;
        }
        if (other.getReadonlyRootFilesystem() != null && !other.getReadonlyRootFilesystem().equals(this.getReadonlyRootFilesystem())) {
            return false;
        }
        if (other.getDnsServers() == null ^ this.getDnsServers() == null) {
            return false;
        }
        if (other.getDnsServers() != null && !other.getDnsServers().equals(this.getDnsServers())) {
            return false;
        }
        if (other.getDnsSearchDomains() == null ^ this.getDnsSearchDomains() == null) {
            return false;
        }
        if (other.getDnsSearchDomains() != null && !other.getDnsSearchDomains().equals(this.getDnsSearchDomains())) {
            return false;
        }
        if (other.getExtraHosts() == null ^ this.getExtraHosts() == null) {
            return false;
        }
        if (other.getExtraHosts() != null && !other.getExtraHosts().equals(this.getExtraHosts())) {
            return false;
        }
        if (other.getDockerSecurityOptions() == null ^ this.getDockerSecurityOptions() == null) {
            return false;
        }
        if (other.getDockerSecurityOptions() != null && !other.getDockerSecurityOptions().equals(this.getDockerSecurityOptions())) {
            return false;
        }
        if (other.getDockerLabels() == null ^ this.getDockerLabels() == null) {
            return false;
        }
        if (other.getDockerLabels() != null && !other.getDockerLabels().equals(this.getDockerLabels())) {
            return false;
        }
        if (other.getUlimits() == null ^ this.getUlimits() == null) {
            return false;
        }
        if (other.getUlimits() != null && !other.getUlimits().equals(this.getUlimits())) {
            return false;
        }
        if (other.getLogConfiguration() == null ^ this.getLogConfiguration() == null) {
            return false;
        }
        return other.getLogConfiguration() == null || other.getLogConfiguration().equals(this.getLogConfiguration());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getImage() == null ? 0 : this.getImage().hashCode());
        hashCode = 31 * hashCode + (this.getCpu() == null ? 0 : this.getCpu().hashCode());
        hashCode = 31 * hashCode + (this.getMemory() == null ? 0 : this.getMemory().hashCode());
        hashCode = 31 * hashCode + (this.getMemoryReservation() == null ? 0 : this.getMemoryReservation().hashCode());
        hashCode = 31 * hashCode + (this.getLinks() == null ? 0 : this.getLinks().hashCode());
        hashCode = 31 * hashCode + (this.getPortMappings() == null ? 0 : this.getPortMappings().hashCode());
        hashCode = 31 * hashCode + (this.getEssential() == null ? 0 : this.getEssential().hashCode());
        hashCode = 31 * hashCode + (this.getEntryPoint() == null ? 0 : this.getEntryPoint().hashCode());
        hashCode = 31 * hashCode + (this.getCommand() == null ? 0 : this.getCommand().hashCode());
        hashCode = 31 * hashCode + (this.getEnvironment() == null ? 0 : this.getEnvironment().hashCode());
        hashCode = 31 * hashCode + (this.getMountPoints() == null ? 0 : this.getMountPoints().hashCode());
        hashCode = 31 * hashCode + (this.getVolumesFrom() == null ? 0 : this.getVolumesFrom().hashCode());
        hashCode = 31 * hashCode + (this.getHostname() == null ? 0 : this.getHostname().hashCode());
        hashCode = 31 * hashCode + (this.getUser() == null ? 0 : this.getUser().hashCode());
        hashCode = 31 * hashCode + (this.getWorkingDirectory() == null ? 0 : this.getWorkingDirectory().hashCode());
        hashCode = 31 * hashCode + (this.getDisableNetworking() == null ? 0 : this.getDisableNetworking().hashCode());
        hashCode = 31 * hashCode + (this.getPrivileged() == null ? 0 : this.getPrivileged().hashCode());
        hashCode = 31 * hashCode + (this.getReadonlyRootFilesystem() == null ? 0 : this.getReadonlyRootFilesystem().hashCode());
        hashCode = 31 * hashCode + (this.getDnsServers() == null ? 0 : this.getDnsServers().hashCode());
        hashCode = 31 * hashCode + (this.getDnsSearchDomains() == null ? 0 : this.getDnsSearchDomains().hashCode());
        hashCode = 31 * hashCode + (this.getExtraHosts() == null ? 0 : this.getExtraHosts().hashCode());
        hashCode = 31 * hashCode + (this.getDockerSecurityOptions() == null ? 0 : this.getDockerSecurityOptions().hashCode());
        hashCode = 31 * hashCode + (this.getDockerLabels() == null ? 0 : this.getDockerLabels().hashCode());
        hashCode = 31 * hashCode + (this.getUlimits() == null ? 0 : this.getUlimits().hashCode());
        hashCode = 31 * hashCode + (this.getLogConfiguration() == null ? 0 : this.getLogConfiguration().hashCode());
        return hashCode;
    }

    public ContainerDefinition clone() {
        try {
            return (ContainerDefinition)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

