/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.ecs.model.ContainerDefinition;
import java.util.List;
import java.util.Map;

@SdkInternalApi
public class ContainerDefinitionMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").build();
    private static final MarshallingInfo<String> IMAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("image").build();
    private static final MarshallingInfo<StructuredPojo> REPOSITORYCREDENTIALS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("repositoryCredentials").build();
    private static final MarshallingInfo<Integer> CPU_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("cpu").build();
    private static final MarshallingInfo<Integer> MEMORY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("memory").build();
    private static final MarshallingInfo<Integer> MEMORYRESERVATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("memoryReservation").build();
    private static final MarshallingInfo<List> LINKS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("links").build();
    private static final MarshallingInfo<List> PORTMAPPINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("portMappings").build();
    private static final MarshallingInfo<Boolean> ESSENTIAL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("essential").build();
    private static final MarshallingInfo<List> ENTRYPOINT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("entryPoint").build();
    private static final MarshallingInfo<List> COMMAND_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("command").build();
    private static final MarshallingInfo<List> ENVIRONMENT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("environment").build();
    private static final MarshallingInfo<List> MOUNTPOINTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("mountPoints").build();
    private static final MarshallingInfo<List> VOLUMESFROM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("volumesFrom").build();
    private static final MarshallingInfo<StructuredPojo> LINUXPARAMETERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("linuxParameters").build();
    private static final MarshallingInfo<List> SECRETS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("secrets").build();
    private static final MarshallingInfo<List> DEPENDSON_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("dependsOn").build();
    private static final MarshallingInfo<Integer> STARTTIMEOUT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("startTimeout").build();
    private static final MarshallingInfo<Integer> STOPTIMEOUT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("stopTimeout").build();
    private static final MarshallingInfo<String> HOSTNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("hostname").build();
    private static final MarshallingInfo<String> USER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("user").build();
    private static final MarshallingInfo<String> WORKINGDIRECTORY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("workingDirectory").build();
    private static final MarshallingInfo<Boolean> DISABLENETWORKING_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("disableNetworking").build();
    private static final MarshallingInfo<Boolean> PRIVILEGED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("privileged").build();
    private static final MarshallingInfo<Boolean> READONLYROOTFILESYSTEM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("readonlyRootFilesystem").build();
    private static final MarshallingInfo<List> DNSSERVERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("dnsServers").build();
    private static final MarshallingInfo<List> DNSSEARCHDOMAINS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("dnsSearchDomains").build();
    private static final MarshallingInfo<List> EXTRAHOSTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("extraHosts").build();
    private static final MarshallingInfo<List> DOCKERSECURITYOPTIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("dockerSecurityOptions").build();
    private static final MarshallingInfo<Boolean> INTERACTIVE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("interactive").build();
    private static final MarshallingInfo<Boolean> PSEUDOTERMINAL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("pseudoTerminal").build();
    private static final MarshallingInfo<Map> DOCKERLABELS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("dockerLabels").build();
    private static final MarshallingInfo<List> ULIMITS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ulimits").build();
    private static final MarshallingInfo<StructuredPojo> LOGCONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("logConfiguration").build();
    private static final MarshallingInfo<StructuredPojo> HEALTHCHECK_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("healthCheck").build();
    private static final MarshallingInfo<List> SYSTEMCONTROLS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("systemControls").build();
    private static final MarshallingInfo<List> RESOURCEREQUIREMENTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("resourceRequirements").build();
    private static final MarshallingInfo<StructuredPojo> FIRELENSCONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("firelensConfiguration").build();
    private static final ContainerDefinitionMarshaller instance = new ContainerDefinitionMarshaller();

    public static ContainerDefinitionMarshaller getInstance() {
        return instance;
    }

    public void marshall(ContainerDefinition containerDefinition, ProtocolMarshaller protocolMarshaller) {
        if (containerDefinition == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)containerDefinition.getName(), NAME_BINDING);
            protocolMarshaller.marshall((Object)containerDefinition.getImage(), IMAGE_BINDING);
            protocolMarshaller.marshall((Object)containerDefinition.getRepositoryCredentials(), REPOSITORYCREDENTIALS_BINDING);
            protocolMarshaller.marshall((Object)containerDefinition.getCpu(), CPU_BINDING);
            protocolMarshaller.marshall((Object)containerDefinition.getMemory(), MEMORY_BINDING);
            protocolMarshaller.marshall((Object)containerDefinition.getMemoryReservation(), MEMORYRESERVATION_BINDING);
            protocolMarshaller.marshall(containerDefinition.getLinks(), LINKS_BINDING);
            protocolMarshaller.marshall(containerDefinition.getPortMappings(), PORTMAPPINGS_BINDING);
            protocolMarshaller.marshall((Object)containerDefinition.getEssential(), ESSENTIAL_BINDING);
            protocolMarshaller.marshall(containerDefinition.getEntryPoint(), ENTRYPOINT_BINDING);
            protocolMarshaller.marshall(containerDefinition.getCommand(), COMMAND_BINDING);
            protocolMarshaller.marshall(containerDefinition.getEnvironment(), ENVIRONMENT_BINDING);
            protocolMarshaller.marshall(containerDefinition.getMountPoints(), MOUNTPOINTS_BINDING);
            protocolMarshaller.marshall(containerDefinition.getVolumesFrom(), VOLUMESFROM_BINDING);
            protocolMarshaller.marshall((Object)containerDefinition.getLinuxParameters(), LINUXPARAMETERS_BINDING);
            protocolMarshaller.marshall(containerDefinition.getSecrets(), SECRETS_BINDING);
            protocolMarshaller.marshall(containerDefinition.getDependsOn(), DEPENDSON_BINDING);
            protocolMarshaller.marshall((Object)containerDefinition.getStartTimeout(), STARTTIMEOUT_BINDING);
            protocolMarshaller.marshall((Object)containerDefinition.getStopTimeout(), STOPTIMEOUT_BINDING);
            protocolMarshaller.marshall((Object)containerDefinition.getHostname(), HOSTNAME_BINDING);
            protocolMarshaller.marshall((Object)containerDefinition.getUser(), USER_BINDING);
            protocolMarshaller.marshall((Object)containerDefinition.getWorkingDirectory(), WORKINGDIRECTORY_BINDING);
            protocolMarshaller.marshall((Object)containerDefinition.getDisableNetworking(), DISABLENETWORKING_BINDING);
            protocolMarshaller.marshall((Object)containerDefinition.getPrivileged(), PRIVILEGED_BINDING);
            protocolMarshaller.marshall((Object)containerDefinition.getReadonlyRootFilesystem(), READONLYROOTFILESYSTEM_BINDING);
            protocolMarshaller.marshall(containerDefinition.getDnsServers(), DNSSERVERS_BINDING);
            protocolMarshaller.marshall(containerDefinition.getDnsSearchDomains(), DNSSEARCHDOMAINS_BINDING);
            protocolMarshaller.marshall(containerDefinition.getExtraHosts(), EXTRAHOSTS_BINDING);
            protocolMarshaller.marshall(containerDefinition.getDockerSecurityOptions(), DOCKERSECURITYOPTIONS_BINDING);
            protocolMarshaller.marshall((Object)containerDefinition.getInteractive(), INTERACTIVE_BINDING);
            protocolMarshaller.marshall((Object)containerDefinition.getPseudoTerminal(), PSEUDOTERMINAL_BINDING);
            protocolMarshaller.marshall(containerDefinition.getDockerLabels(), DOCKERLABELS_BINDING);
            protocolMarshaller.marshall(containerDefinition.getUlimits(), ULIMITS_BINDING);
            protocolMarshaller.marshall((Object)containerDefinition.getLogConfiguration(), LOGCONFIGURATION_BINDING);
            protocolMarshaller.marshall((Object)containerDefinition.getHealthCheck(), HEALTHCHECK_BINDING);
            protocolMarshaller.marshall(containerDefinition.getSystemControls(), SYSTEMCONTROLS_BINDING);
            protocolMarshaller.marshall(containerDefinition.getResourceRequirements(), RESOURCEREQUIREMENTS_BINDING);
            protocolMarshaller.marshall((Object)containerDefinition.getFirelensConfiguration(), FIRELENSCONFIGURATION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

