/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.ecs.model.ListTaskDefinitionsRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class ListTaskDefinitionsRequestMarshaller
implements Marshaller<Request<ListTaskDefinitionsRequest>, ListTaskDefinitionsRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public ListTaskDefinitionsRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<ListTaskDefinitionsRequest> marshall(ListTaskDefinitionsRequest listTaskDefinitionsRequest) {
        if (listTaskDefinitionsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listTaskDefinitionsRequest, "AmazonECS");
        request.addHeader("X-Amz-Target", "AmazonEC2ContainerServiceV20141113.ListTaskDefinitions");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (listTaskDefinitionsRequest.getFamilyPrefix() != null) {
                jsonGenerator.writeFieldName("familyPrefix").writeValue(listTaskDefinitionsRequest.getFamilyPrefix());
            }
            if (listTaskDefinitionsRequest.getStatus() != null) {
                jsonGenerator.writeFieldName("status").writeValue(listTaskDefinitionsRequest.getStatus());
            }
            if (listTaskDefinitionsRequest.getSort() != null) {
                jsonGenerator.writeFieldName("sort").writeValue(listTaskDefinitionsRequest.getSort());
            }
            if (listTaskDefinitionsRequest.getNextToken() != null) {
                jsonGenerator.writeFieldName("nextToken").writeValue(listTaskDefinitionsRequest.getNextToken());
            }
            if (listTaskDefinitionsRequest.getMaxResults() != null) {
                jsonGenerator.writeFieldName("maxResults").writeValue(listTaskDefinitionsRequest.getMaxResults().intValue());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

