/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ecs.model.NetworkBinding;
import com.amazonaws.services.ecs.model.SubmitContainerStateChangeRequest;
import com.amazonaws.services.ecs.model.transform.NetworkBindingJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonGenerator;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class SubmitContainerStateChangeRequestMarshaller
implements Marshaller<Request<SubmitContainerStateChangeRequest>, SubmitContainerStateChangeRequest> {
    public Request<SubmitContainerStateChangeRequest> marshall(SubmitContainerStateChangeRequest submitContainerStateChangeRequest) {
        if (submitContainerStateChangeRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)submitContainerStateChangeRequest, "AmazonECS");
        request.addHeader("X-Amz-Target", "AmazonEC2ContainerServiceV20141113.SubmitContainerStateChange");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList networkBindingsList;
            SdkJsonGenerator jsonGenerator = new SdkJsonGenerator();
            jsonGenerator.writeStartObject();
            if (submitContainerStateChangeRequest.getCluster() != null) {
                jsonGenerator.writeFieldName("cluster").writeValue(submitContainerStateChangeRequest.getCluster());
            }
            if (submitContainerStateChangeRequest.getTask() != null) {
                jsonGenerator.writeFieldName("task").writeValue(submitContainerStateChangeRequest.getTask());
            }
            if (submitContainerStateChangeRequest.getContainerName() != null) {
                jsonGenerator.writeFieldName("containerName").writeValue(submitContainerStateChangeRequest.getContainerName());
            }
            if (submitContainerStateChangeRequest.getStatus() != null) {
                jsonGenerator.writeFieldName("status").writeValue(submitContainerStateChangeRequest.getStatus());
            }
            if (submitContainerStateChangeRequest.getExitCode() != null) {
                jsonGenerator.writeFieldName("exitCode").writeValue((long)submitContainerStateChangeRequest.getExitCode().intValue());
            }
            if (submitContainerStateChangeRequest.getReason() != null) {
                jsonGenerator.writeFieldName("reason").writeValue(submitContainerStateChangeRequest.getReason());
            }
            if (!(networkBindingsList = (SdkInternalList)submitContainerStateChangeRequest.getNetworkBindings()).isEmpty() || !networkBindingsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("networkBindings");
                jsonGenerator.writeStartArray();
                for (NetworkBinding networkBindingsListValue : networkBindingsList) {
                    if (networkBindingsListValue == null) continue;
                    NetworkBindingJsonMarshaller.getInstance().marshall(networkBindingsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

