/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ecs.model.ContainerDefinition;
import com.amazonaws.services.ecs.model.RegisterTaskDefinitionRequest;
import com.amazonaws.services.ecs.model.Volume;
import com.amazonaws.services.ecs.model.transform.ContainerDefinitionJsonMarshaller;
import com.amazonaws.services.ecs.model.transform.VolumeJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class RegisterTaskDefinitionRequestMarshaller
implements Marshaller<Request<RegisterTaskDefinitionRequest>, RegisterTaskDefinitionRequest> {
    public Request<RegisterTaskDefinitionRequest> marshall(RegisterTaskDefinitionRequest registerTaskDefinitionRequest) {
        if (registerTaskDefinitionRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)registerTaskDefinitionRequest, "AmazonECS");
        request.addHeader("X-Amz-Target", "AmazonEC2ContainerServiceV20141113.RegisterTaskDefinition");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList volumesList;
            SdkInternalList containerDefinitionsList;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter((Writer)stringWriter);
            jsonWriter.object();
            if (registerTaskDefinitionRequest.getFamily() != null) {
                jsonWriter.key("family").value((Object)registerTaskDefinitionRequest.getFamily());
            }
            if (!(containerDefinitionsList = (SdkInternalList)registerTaskDefinitionRequest.getContainerDefinitions()).isEmpty() || !containerDefinitionsList.isAutoConstruct()) {
                jsonWriter.key("containerDefinitions");
                jsonWriter.array();
                for (ContainerDefinition containerDefinitionsListValue : containerDefinitionsList) {
                    if (containerDefinitionsListValue == null) continue;
                    ContainerDefinitionJsonMarshaller.getInstance().marshall(containerDefinitionsListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            if (!(volumesList = (SdkInternalList)registerTaskDefinitionRequest.getVolumes()).isEmpty() || !volumesList.isAutoConstruct()) {
                jsonWriter.key("volumes");
                jsonWriter.array();
                for (Volume volumesListValue : volumesList) {
                    if (volumesListValue == null) continue;
                    VolumeJsonMarshaller.getInstance().marshall(volumesListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

