/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ecs.model.ContainerDefinition;
import com.amazonaws.services.ecs.model.HostEntry;
import com.amazonaws.services.ecs.model.KeyValuePair;
import com.amazonaws.services.ecs.model.MountPoint;
import com.amazonaws.services.ecs.model.PortMapping;
import com.amazonaws.services.ecs.model.Ulimit;
import com.amazonaws.services.ecs.model.VolumeFrom;
import com.amazonaws.services.ecs.model.transform.HostEntryJsonMarshaller;
import com.amazonaws.services.ecs.model.transform.KeyValuePairJsonMarshaller;
import com.amazonaws.services.ecs.model.transform.LogConfigurationJsonMarshaller;
import com.amazonaws.services.ecs.model.transform.MountPointJsonMarshaller;
import com.amazonaws.services.ecs.model.transform.PortMappingJsonMarshaller;
import com.amazonaws.services.ecs.model.transform.UlimitJsonMarshaller;
import com.amazonaws.services.ecs.model.transform.VolumeFromJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;
import java.util.Map;

public class ContainerDefinitionJsonMarshaller {
    private static ContainerDefinitionJsonMarshaller instance;

    public void marshall(ContainerDefinition containerDefinition, JSONWriter jsonWriter) {
        if (containerDefinition == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList ulimitsList;
            Map<String, String> dockerLabelsMap;
            SdkInternalList dockerSecurityOptionsList;
            SdkInternalList extraHostsList;
            SdkInternalList dnsSearchDomainsList;
            SdkInternalList dnsServersList;
            SdkInternalList volumesFromList;
            SdkInternalList mountPointsList;
            SdkInternalList environmentList;
            SdkInternalList commandList;
            SdkInternalList entryPointList;
            SdkInternalList portMappingsList;
            SdkInternalList linksList;
            jsonWriter.object();
            if (containerDefinition.getName() != null) {
                jsonWriter.key("name").value((Object)containerDefinition.getName());
            }
            if (containerDefinition.getImage() != null) {
                jsonWriter.key("image").value((Object)containerDefinition.getImage());
            }
            if (containerDefinition.getCpu() != null) {
                jsonWriter.key("cpu").value((Object)containerDefinition.getCpu());
            }
            if (containerDefinition.getMemory() != null) {
                jsonWriter.key("memory").value((Object)containerDefinition.getMemory());
            }
            if (!(linksList = (SdkInternalList)containerDefinition.getLinks()).isEmpty() || !linksList.isAutoConstruct()) {
                jsonWriter.key("links");
                jsonWriter.array();
                for (String linksListValue : linksList) {
                    if (linksListValue == null) continue;
                    jsonWriter.value((Object)linksListValue);
                }
                jsonWriter.endArray();
            }
            if (!(portMappingsList = (SdkInternalList)containerDefinition.getPortMappings()).isEmpty() || !portMappingsList.isAutoConstruct()) {
                jsonWriter.key("portMappings");
                jsonWriter.array();
                for (PortMapping portMappingsListValue : portMappingsList) {
                    if (portMappingsListValue == null) continue;
                    PortMappingJsonMarshaller.getInstance().marshall(portMappingsListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            if (containerDefinition.getEssential() != null) {
                jsonWriter.key("essential").value((Object)containerDefinition.getEssential());
            }
            if (!(entryPointList = (SdkInternalList)containerDefinition.getEntryPoint()).isEmpty() || !entryPointList.isAutoConstruct()) {
                jsonWriter.key("entryPoint");
                jsonWriter.array();
                for (String entryPointListValue : entryPointList) {
                    if (entryPointListValue == null) continue;
                    jsonWriter.value((Object)entryPointListValue);
                }
                jsonWriter.endArray();
            }
            if (!(commandList = (SdkInternalList)containerDefinition.getCommand()).isEmpty() || !commandList.isAutoConstruct()) {
                jsonWriter.key("command");
                jsonWriter.array();
                for (String commandListValue : commandList) {
                    if (commandListValue == null) continue;
                    jsonWriter.value((Object)commandListValue);
                }
                jsonWriter.endArray();
            }
            if (!(environmentList = (SdkInternalList)containerDefinition.getEnvironment()).isEmpty() || !environmentList.isAutoConstruct()) {
                jsonWriter.key("environment");
                jsonWriter.array();
                for (KeyValuePair environmentListValue : environmentList) {
                    if (environmentListValue == null) continue;
                    KeyValuePairJsonMarshaller.getInstance().marshall(environmentListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            if (!(mountPointsList = (SdkInternalList)containerDefinition.getMountPoints()).isEmpty() || !mountPointsList.isAutoConstruct()) {
                jsonWriter.key("mountPoints");
                jsonWriter.array();
                for (MountPoint mountPointsListValue : mountPointsList) {
                    if (mountPointsListValue == null) continue;
                    MountPointJsonMarshaller.getInstance().marshall(mountPointsListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            if (!(volumesFromList = (SdkInternalList)containerDefinition.getVolumesFrom()).isEmpty() || !volumesFromList.isAutoConstruct()) {
                jsonWriter.key("volumesFrom");
                jsonWriter.array();
                for (VolumeFrom volumesFromListValue : volumesFromList) {
                    if (volumesFromListValue == null) continue;
                    VolumeFromJsonMarshaller.getInstance().marshall(volumesFromListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            if (containerDefinition.getHostname() != null) {
                jsonWriter.key("hostname").value((Object)containerDefinition.getHostname());
            }
            if (containerDefinition.getUser() != null) {
                jsonWriter.key("user").value((Object)containerDefinition.getUser());
            }
            if (containerDefinition.getWorkingDirectory() != null) {
                jsonWriter.key("workingDirectory").value((Object)containerDefinition.getWorkingDirectory());
            }
            if (containerDefinition.getDisableNetworking() != null) {
                jsonWriter.key("disableNetworking").value((Object)containerDefinition.getDisableNetworking());
            }
            if (containerDefinition.getPrivileged() != null) {
                jsonWriter.key("privileged").value((Object)containerDefinition.getPrivileged());
            }
            if (containerDefinition.getReadonlyRootFilesystem() != null) {
                jsonWriter.key("readonlyRootFilesystem").value((Object)containerDefinition.getReadonlyRootFilesystem());
            }
            if (!(dnsServersList = (SdkInternalList)containerDefinition.getDnsServers()).isEmpty() || !dnsServersList.isAutoConstruct()) {
                jsonWriter.key("dnsServers");
                jsonWriter.array();
                for (String dnsServersListValue : dnsServersList) {
                    if (dnsServersListValue == null) continue;
                    jsonWriter.value((Object)dnsServersListValue);
                }
                jsonWriter.endArray();
            }
            if (!(dnsSearchDomainsList = (SdkInternalList)containerDefinition.getDnsSearchDomains()).isEmpty() || !dnsSearchDomainsList.isAutoConstruct()) {
                jsonWriter.key("dnsSearchDomains");
                jsonWriter.array();
                for (String dnsSearchDomainsListValue : dnsSearchDomainsList) {
                    if (dnsSearchDomainsListValue == null) continue;
                    jsonWriter.value((Object)dnsSearchDomainsListValue);
                }
                jsonWriter.endArray();
            }
            if (!(extraHostsList = (SdkInternalList)containerDefinition.getExtraHosts()).isEmpty() || !extraHostsList.isAutoConstruct()) {
                jsonWriter.key("extraHosts");
                jsonWriter.array();
                for (HostEntry extraHostsListValue : extraHostsList) {
                    if (extraHostsListValue == null) continue;
                    HostEntryJsonMarshaller.getInstance().marshall(extraHostsListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            if (!(dockerSecurityOptionsList = (SdkInternalList)containerDefinition.getDockerSecurityOptions()).isEmpty() || !dockerSecurityOptionsList.isAutoConstruct()) {
                jsonWriter.key("dockerSecurityOptions");
                jsonWriter.array();
                for (String dockerSecurityOptionsListValue : dockerSecurityOptionsList) {
                    if (dockerSecurityOptionsListValue == null) continue;
                    jsonWriter.value((Object)dockerSecurityOptionsListValue);
                }
                jsonWriter.endArray();
            }
            if ((dockerLabelsMap = containerDefinition.getDockerLabels()) != null) {
                jsonWriter.key("dockerLabels");
                jsonWriter.object();
                for (Map.Entry<String, String> dockerLabelsMapValue : dockerLabelsMap.entrySet()) {
                    if (dockerLabelsMapValue.getValue() == null) continue;
                    jsonWriter.key(dockerLabelsMapValue.getKey());
                    jsonWriter.value((Object)dockerLabelsMapValue.getValue());
                }
                jsonWriter.endObject();
            }
            if (!(ulimitsList = (SdkInternalList)containerDefinition.getUlimits()).isEmpty() || !ulimitsList.isAutoConstruct()) {
                jsonWriter.key("ulimits");
                jsonWriter.array();
                for (Ulimit ulimitsListValue : ulimitsList) {
                    if (ulimitsListValue == null) continue;
                    UlimitJsonMarshaller.getInstance().marshall(ulimitsListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            if (containerDefinition.getLogConfiguration() != null) {
                jsonWriter.key("logConfiguration");
                LogConfigurationJsonMarshaller.getInstance().marshall(containerDefinition.getLogConfiguration(), jsonWriter);
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ContainerDefinitionJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ContainerDefinitionJsonMarshaller();
        }
        return instance;
    }
}

