/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.ecs.model.Volume;
import com.amazonaws.services.ecs.model.transform.HostVolumePropertiesJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;

public class VolumeJsonMarshaller {
    private static VolumeJsonMarshaller instance;

    public void marshall(Volume volume, JSONWriter jsonWriter) {
        if (volume == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonWriter.object();
            if (volume.getName() != null) {
                jsonWriter.key("name").value((Object)volume.getName());
            }
            if (volume.getHost() != null) {
                jsonWriter.key("host");
                HostVolumePropertiesJsonMarshaller.getInstance().marshall(volume.getHost(), jsonWriter);
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static VolumeJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new VolumeJsonMarshaller();
        }
        return instance;
    }
}

