/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.ecs.model.ContainerDefinition;
import com.amazonaws.services.ecs.model.HostEntry;
import com.amazonaws.services.ecs.model.HostVolumeProperties;
import com.amazonaws.services.ecs.model.KeyValuePair;
import com.amazonaws.services.ecs.model.LogConfiguration;
import com.amazonaws.services.ecs.model.MountPoint;
import com.amazonaws.services.ecs.model.PortMapping;
import com.amazonaws.services.ecs.model.RegisterTaskDefinitionRequest;
import com.amazonaws.services.ecs.model.Ulimit;
import com.amazonaws.services.ecs.model.Volume;
import com.amazonaws.services.ecs.model.VolumeFrom;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;

public class RegisterTaskDefinitionRequestMarshaller
implements Marshaller<Request<RegisterTaskDefinitionRequest>, RegisterTaskDefinitionRequest> {
    public Request<RegisterTaskDefinitionRequest> marshall(RegisterTaskDefinitionRequest registerTaskDefinitionRequest) {
        if (registerTaskDefinitionRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)registerTaskDefinitionRequest, "AmazonECS");
        String target = "AmazonEC2ContainerServiceV20141113.RegisterTaskDefinition";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            ListWithAutoConstructFlag volumesList;
            ListWithAutoConstructFlag containerDefinitionsList;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter((Writer)stringWriter);
            jsonWriter.object();
            if (registerTaskDefinitionRequest.getFamily() != null) {
                jsonWriter.key("family").value((Object)registerTaskDefinitionRequest.getFamily());
            }
            if (!((containerDefinitionsList = (ListWithAutoConstructFlag)registerTaskDefinitionRequest.getContainerDefinitions()) == null || containerDefinitionsList.isAutoConstruct() && containerDefinitionsList.isEmpty())) {
                jsonWriter.key("containerDefinitions");
                jsonWriter.array();
                for (ContainerDefinition containerDefinitionsListValue : containerDefinitionsList) {
                    LogConfiguration logConfiguration;
                    ListWithAutoConstructFlag ulimitsList;
                    ListWithAutoConstructFlag dockerSecurityOptionsList;
                    ListWithAutoConstructFlag extraHostsList;
                    ListWithAutoConstructFlag dnsSearchDomainsList;
                    ListWithAutoConstructFlag dnsServersList;
                    ListWithAutoConstructFlag volumesFromList;
                    ListWithAutoConstructFlag mountPointsList;
                    ListWithAutoConstructFlag environmentList;
                    ListWithAutoConstructFlag commandList;
                    ListWithAutoConstructFlag entryPointList;
                    ListWithAutoConstructFlag portMappingsList;
                    ListWithAutoConstructFlag linksList;
                    if (containerDefinitionsListValue == null) continue;
                    jsonWriter.object();
                    if (containerDefinitionsListValue.getName() != null) {
                        jsonWriter.key("name").value((Object)containerDefinitionsListValue.getName());
                    }
                    if (containerDefinitionsListValue.getImage() != null) {
                        jsonWriter.key("image").value((Object)containerDefinitionsListValue.getImage());
                    }
                    if (containerDefinitionsListValue.getCpu() != null) {
                        jsonWriter.key("cpu").value((Object)containerDefinitionsListValue.getCpu());
                    }
                    if (containerDefinitionsListValue.getMemory() != null) {
                        jsonWriter.key("memory").value((Object)containerDefinitionsListValue.getMemory());
                    }
                    if (!((linksList = (ListWithAutoConstructFlag)containerDefinitionsListValue.getLinks()) == null || linksList.isAutoConstruct() && linksList.isEmpty())) {
                        jsonWriter.key("links");
                        jsonWriter.array();
                        for (String linksListValue : linksList) {
                            if (linksListValue == null) continue;
                            jsonWriter.value((Object)linksListValue);
                        }
                        jsonWriter.endArray();
                    }
                    if (!((portMappingsList = (ListWithAutoConstructFlag)containerDefinitionsListValue.getPortMappings()) == null || portMappingsList.isAutoConstruct() && portMappingsList.isEmpty())) {
                        jsonWriter.key("portMappings");
                        jsonWriter.array();
                        for (PortMapping portMappingsListValue : portMappingsList) {
                            if (portMappingsListValue == null) continue;
                            jsonWriter.object();
                            if (portMappingsListValue.getContainerPort() != null) {
                                jsonWriter.key("containerPort").value((Object)portMappingsListValue.getContainerPort());
                            }
                            if (portMappingsListValue.getHostPort() != null) {
                                jsonWriter.key("hostPort").value((Object)portMappingsListValue.getHostPort());
                            }
                            if (portMappingsListValue.getProtocol() != null) {
                                jsonWriter.key("protocol").value((Object)portMappingsListValue.getProtocol());
                            }
                            jsonWriter.endObject();
                        }
                        jsonWriter.endArray();
                    }
                    if (containerDefinitionsListValue.isEssential() != null) {
                        jsonWriter.key("essential").value((Object)containerDefinitionsListValue.isEssential());
                    }
                    if (!((entryPointList = (ListWithAutoConstructFlag)containerDefinitionsListValue.getEntryPoint()) == null || entryPointList.isAutoConstruct() && entryPointList.isEmpty())) {
                        jsonWriter.key("entryPoint");
                        jsonWriter.array();
                        for (String entryPointListValue : entryPointList) {
                            if (entryPointListValue == null) continue;
                            jsonWriter.value((Object)entryPointListValue);
                        }
                        jsonWriter.endArray();
                    }
                    if (!((commandList = (ListWithAutoConstructFlag)containerDefinitionsListValue.getCommand()) == null || commandList.isAutoConstruct() && commandList.isEmpty())) {
                        jsonWriter.key("command");
                        jsonWriter.array();
                        for (String commandListValue : commandList) {
                            if (commandListValue == null) continue;
                            jsonWriter.value((Object)commandListValue);
                        }
                        jsonWriter.endArray();
                    }
                    if (!((environmentList = (ListWithAutoConstructFlag)containerDefinitionsListValue.getEnvironment()) == null || environmentList.isAutoConstruct() && environmentList.isEmpty())) {
                        jsonWriter.key("environment");
                        jsonWriter.array();
                        for (KeyValuePair environmentListValue : environmentList) {
                            if (environmentListValue == null) continue;
                            jsonWriter.object();
                            if (environmentListValue.getName() != null) {
                                jsonWriter.key("name").value((Object)environmentListValue.getName());
                            }
                            if (environmentListValue.getValue() != null) {
                                jsonWriter.key("value").value((Object)environmentListValue.getValue());
                            }
                            jsonWriter.endObject();
                        }
                        jsonWriter.endArray();
                    }
                    if (!((mountPointsList = (ListWithAutoConstructFlag)containerDefinitionsListValue.getMountPoints()) == null || mountPointsList.isAutoConstruct() && mountPointsList.isEmpty())) {
                        jsonWriter.key("mountPoints");
                        jsonWriter.array();
                        for (MountPoint mountPointsListValue : mountPointsList) {
                            if (mountPointsListValue == null) continue;
                            jsonWriter.object();
                            if (mountPointsListValue.getSourceVolume() != null) {
                                jsonWriter.key("sourceVolume").value((Object)mountPointsListValue.getSourceVolume());
                            }
                            if (mountPointsListValue.getContainerPath() != null) {
                                jsonWriter.key("containerPath").value((Object)mountPointsListValue.getContainerPath());
                            }
                            if (mountPointsListValue.isReadOnly() != null) {
                                jsonWriter.key("readOnly").value((Object)mountPointsListValue.isReadOnly());
                            }
                            jsonWriter.endObject();
                        }
                        jsonWriter.endArray();
                    }
                    if (!((volumesFromList = (ListWithAutoConstructFlag)containerDefinitionsListValue.getVolumesFrom()) == null || volumesFromList.isAutoConstruct() && volumesFromList.isEmpty())) {
                        jsonWriter.key("volumesFrom");
                        jsonWriter.array();
                        for (VolumeFrom volumesFromListValue : volumesFromList) {
                            if (volumesFromListValue == null) continue;
                            jsonWriter.object();
                            if (volumesFromListValue.getSourceContainer() != null) {
                                jsonWriter.key("sourceContainer").value((Object)volumesFromListValue.getSourceContainer());
                            }
                            if (volumesFromListValue.isReadOnly() != null) {
                                jsonWriter.key("readOnly").value((Object)volumesFromListValue.isReadOnly());
                            }
                            jsonWriter.endObject();
                        }
                        jsonWriter.endArray();
                    }
                    if (containerDefinitionsListValue.getHostname() != null) {
                        jsonWriter.key("hostname").value((Object)containerDefinitionsListValue.getHostname());
                    }
                    if (containerDefinitionsListValue.getUser() != null) {
                        jsonWriter.key("user").value((Object)containerDefinitionsListValue.getUser());
                    }
                    if (containerDefinitionsListValue.getWorkingDirectory() != null) {
                        jsonWriter.key("workingDirectory").value((Object)containerDefinitionsListValue.getWorkingDirectory());
                    }
                    if (containerDefinitionsListValue.isDisableNetworking() != null) {
                        jsonWriter.key("disableNetworking").value((Object)containerDefinitionsListValue.isDisableNetworking());
                    }
                    if (containerDefinitionsListValue.isPrivileged() != null) {
                        jsonWriter.key("privileged").value((Object)containerDefinitionsListValue.isPrivileged());
                    }
                    if (containerDefinitionsListValue.isReadonlyRootFilesystem() != null) {
                        jsonWriter.key("readonlyRootFilesystem").value((Object)containerDefinitionsListValue.isReadonlyRootFilesystem());
                    }
                    if (!((dnsServersList = (ListWithAutoConstructFlag)containerDefinitionsListValue.getDnsServers()) == null || dnsServersList.isAutoConstruct() && dnsServersList.isEmpty())) {
                        jsonWriter.key("dnsServers");
                        jsonWriter.array();
                        for (String dnsServersListValue : dnsServersList) {
                            if (dnsServersListValue == null) continue;
                            jsonWriter.value((Object)dnsServersListValue);
                        }
                        jsonWriter.endArray();
                    }
                    if (!((dnsSearchDomainsList = (ListWithAutoConstructFlag)containerDefinitionsListValue.getDnsSearchDomains()) == null || dnsSearchDomainsList.isAutoConstruct() && dnsSearchDomainsList.isEmpty())) {
                        jsonWriter.key("dnsSearchDomains");
                        jsonWriter.array();
                        for (String dnsSearchDomainsListValue : dnsSearchDomainsList) {
                            if (dnsSearchDomainsListValue == null) continue;
                            jsonWriter.value((Object)dnsSearchDomainsListValue);
                        }
                        jsonWriter.endArray();
                    }
                    if (!((extraHostsList = (ListWithAutoConstructFlag)containerDefinitionsListValue.getExtraHosts()) == null || extraHostsList.isAutoConstruct() && extraHostsList.isEmpty())) {
                        jsonWriter.key("extraHosts");
                        jsonWriter.array();
                        for (HostEntry extraHostsListValue : extraHostsList) {
                            if (extraHostsListValue == null) continue;
                            jsonWriter.object();
                            if (extraHostsListValue.getHostname() != null) {
                                jsonWriter.key("hostname").value((Object)extraHostsListValue.getHostname());
                            }
                            if (extraHostsListValue.getIpAddress() != null) {
                                jsonWriter.key("ipAddress").value((Object)extraHostsListValue.getIpAddress());
                            }
                            jsonWriter.endObject();
                        }
                        jsonWriter.endArray();
                    }
                    if (!((dockerSecurityOptionsList = (ListWithAutoConstructFlag)containerDefinitionsListValue.getDockerSecurityOptions()) == null || dockerSecurityOptionsList.isAutoConstruct() && dockerSecurityOptionsList.isEmpty())) {
                        jsonWriter.key("dockerSecurityOptions");
                        jsonWriter.array();
                        for (String dockerSecurityOptionsListValue : dockerSecurityOptionsList) {
                            if (dockerSecurityOptionsListValue == null) continue;
                            jsonWriter.value((Object)dockerSecurityOptionsListValue);
                        }
                        jsonWriter.endArray();
                    }
                    if (containerDefinitionsListValue.getDockerLabels() != null) {
                        jsonWriter.key("dockerLabels");
                        jsonWriter.object();
                        for (Map.Entry<String, String> dockerLabelsListValue : containerDefinitionsListValue.getDockerLabels().entrySet()) {
                            if (dockerLabelsListValue.getValue() == null) continue;
                            jsonWriter.key(dockerLabelsListValue.getKey());
                            jsonWriter.value((Object)dockerLabelsListValue.getValue());
                        }
                        jsonWriter.endObject();
                    }
                    if (!((ulimitsList = (ListWithAutoConstructFlag)containerDefinitionsListValue.getUlimits()) == null || ulimitsList.isAutoConstruct() && ulimitsList.isEmpty())) {
                        jsonWriter.key("ulimits");
                        jsonWriter.array();
                        for (Ulimit ulimitsListValue : ulimitsList) {
                            if (ulimitsListValue == null) continue;
                            jsonWriter.object();
                            if (ulimitsListValue.getName() != null) {
                                jsonWriter.key("name").value((Object)ulimitsListValue.getName());
                            }
                            if (ulimitsListValue.getSoftLimit() != null) {
                                jsonWriter.key("softLimit").value((Object)ulimitsListValue.getSoftLimit());
                            }
                            if (ulimitsListValue.getHardLimit() != null) {
                                jsonWriter.key("hardLimit").value((Object)ulimitsListValue.getHardLimit());
                            }
                            jsonWriter.endObject();
                        }
                        jsonWriter.endArray();
                    }
                    if ((logConfiguration = containerDefinitionsListValue.getLogConfiguration()) != null) {
                        jsonWriter.key("logConfiguration");
                        jsonWriter.object();
                        if (logConfiguration.getLogDriver() != null) {
                            jsonWriter.key("logDriver").value((Object)logConfiguration.getLogDriver());
                        }
                        if (logConfiguration.getOptions() != null) {
                            jsonWriter.key("options");
                            jsonWriter.object();
                            for (Map.Entry<String, String> optionsListValue : logConfiguration.getOptions().entrySet()) {
                                if (optionsListValue.getValue() == null) continue;
                                jsonWriter.key(optionsListValue.getKey());
                                jsonWriter.value((Object)optionsListValue.getValue());
                            }
                            jsonWriter.endObject();
                        }
                        jsonWriter.endObject();
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endArray();
            }
            if (!((volumesList = (ListWithAutoConstructFlag)registerTaskDefinitionRequest.getVolumes()) == null || volumesList.isAutoConstruct() && volumesList.isEmpty())) {
                jsonWriter.key("volumes");
                jsonWriter.array();
                for (Volume volumesListValue : volumesList) {
                    HostVolumeProperties host;
                    if (volumesListValue == null) continue;
                    jsonWriter.object();
                    if (volumesListValue.getName() != null) {
                        jsonWriter.key("name").value((Object)volumesListValue.getName());
                    }
                    if ((host = volumesListValue.getHost()) != null) {
                        jsonWriter.key("host");
                        jsonWriter.object();
                        if (host.getSourcePath() != null) {
                            jsonWriter.key("sourcePath").value((Object)host.getSourcePath());
                        }
                        jsonWriter.endObject();
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

