/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecr.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.ecr.model.ImageScanFindings;
import java.util.Date;
import java.util.List;
import java.util.Map;

@SdkInternalApi
public class ImageScanFindingsMarshaller {
    private static final MarshallingInfo<Date> IMAGESCANCOMPLETEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("imageScanCompletedAt").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> VULNERABILITYSOURCEUPDATEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("vulnerabilitySourceUpdatedAt").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Map> FINDINGSEVERITYCOUNTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("findingSeverityCounts").build();
    private static final MarshallingInfo<List> FINDINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("findings").build();
    private static final MarshallingInfo<List> ENHANCEDFINDINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("enhancedFindings").build();
    private static final ImageScanFindingsMarshaller instance = new ImageScanFindingsMarshaller();

    public static ImageScanFindingsMarshaller getInstance() {
        return instance;
    }

    public void marshall(ImageScanFindings imageScanFindings, ProtocolMarshaller protocolMarshaller) {
        if (imageScanFindings == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)imageScanFindings.getImageScanCompletedAt(), IMAGESCANCOMPLETEDAT_BINDING);
            protocolMarshaller.marshall((Object)imageScanFindings.getVulnerabilitySourceUpdatedAt(), VULNERABILITYSOURCEUPDATEDAT_BINDING);
            protocolMarshaller.marshall(imageScanFindings.getFindingSeverityCounts(), FINDINGSEVERITYCOUNTS_BINDING);
            protocolMarshaller.marshall(imageScanFindings.getFindings(), FINDINGS_BINDING);
            protocolMarshaller.marshall(imageScanFindings.getEnhancedFindings(), ENHANCEDFINDINGS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

