/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecr.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.ecr.model.ImageIdentifier;

public class ImageIdentifierJsonMarshaller {
    private static ImageIdentifierJsonMarshaller instance;

    public void marshall(ImageIdentifier imageIdentifier, StructuredJsonGenerator jsonGenerator) {
        if (imageIdentifier == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (imageIdentifier.getImageDigest() != null) {
                jsonGenerator.writeFieldName("imageDigest").writeValue(imageIdentifier.getImageDigest());
            }
            if (imageIdentifier.getImageTag() != null) {
                jsonGenerator.writeFieldName("imageTag").writeValue(imageIdentifier.getImageTag());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ImageIdentifierJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ImageIdentifierJsonMarshaller();
        }
        return instance;
    }
}

