/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecr.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.ecr.model.Layer;

@SdkInternalApi
public class LayerMarshaller {
    private static final MarshallingInfo<String> LAYERDIGEST_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("layerDigest").build();
    private static final MarshallingInfo<String> LAYERAVAILABILITY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("layerAvailability").build();
    private static final MarshallingInfo<Long> LAYERSIZE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("layerSize").build();
    private static final MarshallingInfo<String> MEDIATYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("mediaType").build();
    private static final LayerMarshaller instance = new LayerMarshaller();

    public static LayerMarshaller getInstance() {
        return instance;
    }

    public void marshall(Layer layer, ProtocolMarshaller protocolMarshaller) {
        if (layer == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)layer.getLayerDigest(), LAYERDIGEST_BINDING);
            protocolMarshaller.marshall((Object)layer.getLayerAvailability(), LAYERAVAILABILITY_BINDING);
            protocolMarshaller.marshall((Object)layer.getLayerSize(), LAYERSIZE_BINDING);
            protocolMarshaller.marshall((Object)layer.getMediaType(), MEDIATYPE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

