/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecr.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.ecr.model.Image;
import com.amazonaws.services.ecr.model.transform.ImageIdentifierJsonMarshaller;
import com.amazonaws.util.json.StructuredJsonGenerator;

public class ImageJsonMarshaller {
    private static ImageJsonMarshaller instance;

    public void marshall(Image image, StructuredJsonGenerator jsonGenerator) {
        if (image == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (image.getRegistryId() != null) {
                jsonGenerator.writeFieldName("registryId").writeValue(image.getRegistryId());
            }
            if (image.getRepositoryName() != null) {
                jsonGenerator.writeFieldName("repositoryName").writeValue(image.getRepositoryName());
            }
            if (image.getImageId() != null) {
                jsonGenerator.writeFieldName("imageId");
                ImageIdentifierJsonMarshaller.getInstance().marshall(image.getImageId(), jsonGenerator);
            }
            if (image.getImageManifest() != null) {
                jsonGenerator.writeFieldName("imageManifest").writeValue(image.getImageManifest());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ImageJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ImageJsonMarshaller();
        }
        return instance;
    }
}

