/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecr.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.ecr.model.UploadLayerPartRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonGenerator;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class UploadLayerPartRequestMarshaller
implements Marshaller<Request<UploadLayerPartRequest>, UploadLayerPartRequest> {
    public Request<UploadLayerPartRequest> marshall(UploadLayerPartRequest uploadLayerPartRequest) {
        if (uploadLayerPartRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)uploadLayerPartRequest, "AmazonECR");
        request.addHeader("X-Amz-Target", "AmazonEC2ContainerRegistry_V20150921.UploadLayerPart");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkJsonGenerator jsonGenerator = new SdkJsonGenerator();
            jsonGenerator.writeStartObject();
            if (uploadLayerPartRequest.getRegistryId() != null) {
                jsonGenerator.writeFieldName("registryId").writeValue(uploadLayerPartRequest.getRegistryId());
            }
            if (uploadLayerPartRequest.getRepositoryName() != null) {
                jsonGenerator.writeFieldName("repositoryName").writeValue(uploadLayerPartRequest.getRepositoryName());
            }
            if (uploadLayerPartRequest.getUploadId() != null) {
                jsonGenerator.writeFieldName("uploadId").writeValue(uploadLayerPartRequest.getUploadId());
            }
            if (uploadLayerPartRequest.getPartFirstByte() != null) {
                jsonGenerator.writeFieldName("partFirstByte").writeValue(uploadLayerPartRequest.getPartFirstByte().longValue());
            }
            if (uploadLayerPartRequest.getPartLastByte() != null) {
                jsonGenerator.writeFieldName("partLastByte").writeValue(uploadLayerPartRequest.getPartLastByte().longValue());
            }
            if (uploadLayerPartRequest.getLayerPartBlob() != null) {
                jsonGenerator.writeFieldName("layerPartBlob").writeValue(uploadLayerPartRequest.getLayerPartBlob());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

