/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.ec2.model.Snapshot;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DescribeSnapshotsResult
implements Serializable {
    private ListWithAutoConstructFlag<Snapshot> snapshots;

    public List<Snapshot> getSnapshots() {
        if (this.snapshots == null) {
            this.snapshots = new ListWithAutoConstructFlag();
            this.snapshots.setAutoConstruct(true);
        }
        return this.snapshots;
    }

    public void setSnapshots(Collection<Snapshot> snapshots) {
        if (snapshots == null) {
            this.snapshots = null;
            return;
        }
        ListWithAutoConstructFlag snapshotsCopy = new ListWithAutoConstructFlag(snapshots.size());
        snapshotsCopy.addAll(snapshots);
        this.snapshots = snapshotsCopy;
    }

    public DescribeSnapshotsResult withSnapshots(Snapshot ... snapshots) {
        if (this.getSnapshots() == null) {
            this.setSnapshots(new ArrayList<Snapshot>(snapshots.length));
        }
        for (Snapshot value : snapshots) {
            this.getSnapshots().add(value);
        }
        return this;
    }

    public DescribeSnapshotsResult withSnapshots(Collection<Snapshot> snapshots) {
        if (snapshots == null) {
            this.snapshots = null;
        } else {
            ListWithAutoConstructFlag snapshotsCopy = new ListWithAutoConstructFlag(snapshots.size());
            snapshotsCopy.addAll(snapshots);
            this.snapshots = snapshotsCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSnapshots() != null) {
            sb.append("Snapshots: " + this.getSnapshots());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSnapshots() == null ? 0 : this.getSnapshots().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSnapshotsResult)) {
            return false;
        }
        DescribeSnapshotsResult other = (DescribeSnapshotsResult)obj;
        if (other.getSnapshots() == null ^ this.getSnapshots() == null) {
            return false;
        }
        return other.getSnapshots() == null || other.getSnapshots().equals(this.getSnapshots());
    }
}

