/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.ec2.model.DescribeSpotPriceHistoryRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.Date;
import java.util.List;

public class DescribeSpotPriceHistoryRequestMarshaller
implements Marshaller<Request<DescribeSpotPriceHistoryRequest>, DescribeSpotPriceHistoryRequest> {
    public Request<DescribeSpotPriceHistoryRequest> marshall(DescribeSpotPriceHistoryRequest describeSpotPriceHistoryRequest) {
        if (describeSpotPriceHistoryRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeSpotPriceHistoryRequest, "AmazonEC2");
        request.addParameter("Action", "DescribeSpotPriceHistory");
        request.addParameter("Version", "2014-09-01");
        if (describeSpotPriceHistoryRequest.getStartTime() != null) {
            request.addParameter("StartTime", StringUtils.fromDate((Date)describeSpotPriceHistoryRequest.getStartTime()));
        }
        if (describeSpotPriceHistoryRequest.getEndTime() != null) {
            request.addParameter("EndTime", StringUtils.fromDate((Date)describeSpotPriceHistoryRequest.getEndTime()));
        }
        List<String> instanceTypesList = describeSpotPriceHistoryRequest.getInstanceTypes();
        int instanceTypesListIndex = 1;
        for (String instanceTypesListValue : instanceTypesList) {
            if (instanceTypesListValue != null) {
                request.addParameter("InstanceType." + instanceTypesListIndex, StringUtils.fromString((String)instanceTypesListValue));
            }
            ++instanceTypesListIndex;
        }
        List<String> productDescriptionsList = describeSpotPriceHistoryRequest.getProductDescriptions();
        int productDescriptionsListIndex = 1;
        for (String productDescriptionsListValue : productDescriptionsList) {
            if (productDescriptionsListValue != null) {
                request.addParameter("ProductDescription." + productDescriptionsListIndex, StringUtils.fromString((String)productDescriptionsListValue));
            }
            ++productDescriptionsListIndex;
        }
        List<Filter> filtersList = describeSpotPriceHistoryRequest.getFilters();
        int filtersListIndex = 1;
        for (Filter filtersListValue : filtersList) {
            Filter filterMember = filtersListValue;
            if (filterMember != null) {
                if (filterMember.getName() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)filterMember.getName()));
                }
                List<String> valuesList = filterMember.getValues();
                int valuesListIndex = 1;
                for (String valuesListValue : valuesList) {
                    if (valuesListValue != null) {
                        request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString((String)valuesListValue));
                    }
                    ++valuesListIndex;
                }
            }
            ++filtersListIndex;
        }
        if (describeSpotPriceHistoryRequest.getAvailabilityZone() != null) {
            request.addParameter("AvailabilityZone", StringUtils.fromString((String)describeSpotPriceHistoryRequest.getAvailabilityZone()));
        }
        if (describeSpotPriceHistoryRequest.getMaxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger((Integer)describeSpotPriceHistoryRequest.getMaxResults()));
        }
        if (describeSpotPriceHistoryRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)describeSpotPriceHistoryRequest.getNextToken()));
        }
        return request;
    }
}

