/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DhcpConfiguration
implements Serializable,
Cloneable {
    private String key;
    private ListWithAutoConstructFlag<String> values;

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public DhcpConfiguration withKey(String key) {
        this.key = key;
        return this;
    }

    public List<String> getValues() {
        if (this.values == null) {
            this.values = new ListWithAutoConstructFlag();
            this.values.setAutoConstruct(true);
        }
        return this.values;
    }

    public void setValues(Collection<String> values) {
        if (values == null) {
            this.values = null;
            return;
        }
        ListWithAutoConstructFlag valuesCopy = new ListWithAutoConstructFlag(values.size());
        valuesCopy.addAll(values);
        this.values = valuesCopy;
    }

    public DhcpConfiguration withValues(String ... values) {
        if (this.getValues() == null) {
            this.setValues(new ArrayList<String>(values.length));
        }
        for (String value : values) {
            this.getValues().add(value);
        }
        return this;
    }

    public DhcpConfiguration withValues(Collection<String> values) {
        if (values == null) {
            this.values = null;
        } else {
            ListWithAutoConstructFlag valuesCopy = new ListWithAutoConstructFlag(values.size());
            valuesCopy.addAll(values);
            this.values = valuesCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getKey() != null) {
            sb.append("Key: " + this.getKey() + ",");
        }
        if (this.getValues() != null) {
            sb.append("Values: " + this.getValues());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getKey() == null ? 0 : this.getKey().hashCode());
        hashCode = 31 * hashCode + (this.getValues() == null ? 0 : this.getValues().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DhcpConfiguration)) {
            return false;
        }
        DhcpConfiguration other = (DhcpConfiguration)obj;
        if (other.getKey() == null ^ this.getKey() == null) {
            return false;
        }
        if (other.getKey() != null && !other.getKey().equals(this.getKey())) {
            return false;
        }
        if (other.getValues() == null ^ this.getValues() == null) {
            return false;
        }
        return other.getValues() == null || other.getValues().equals(this.getValues());
    }

    public DhcpConfiguration clone() {
        try {
            return (DhcpConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

