/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.AddIpamOperatingRegion;
import com.amazonaws.services.ec2.model.DryRunSupportedRequest;
import com.amazonaws.services.ec2.model.IpamTier;
import com.amazonaws.services.ec2.model.RemoveIpamOperatingRegion;
import com.amazonaws.services.ec2.model.transform.ModifyIpamRequestMarshaller;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class ModifyIpamRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable,
DryRunSupportedRequest<ModifyIpamRequest> {
    private String ipamId;
    private String description;
    private SdkInternalList<AddIpamOperatingRegion> addOperatingRegions;
    private SdkInternalList<RemoveIpamOperatingRegion> removeOperatingRegions;
    private String tier;

    public void setIpamId(String ipamId) {
        this.ipamId = ipamId;
    }

    public String getIpamId() {
        return this.ipamId;
    }

    public ModifyIpamRequest withIpamId(String ipamId) {
        this.setIpamId(ipamId);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public ModifyIpamRequest withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public List<AddIpamOperatingRegion> getAddOperatingRegions() {
        if (this.addOperatingRegions == null) {
            this.addOperatingRegions = new SdkInternalList();
        }
        return this.addOperatingRegions;
    }

    public void setAddOperatingRegions(Collection<AddIpamOperatingRegion> addOperatingRegions) {
        if (addOperatingRegions == null) {
            this.addOperatingRegions = null;
            return;
        }
        this.addOperatingRegions = new SdkInternalList(addOperatingRegions);
    }

    public ModifyIpamRequest withAddOperatingRegions(AddIpamOperatingRegion ... addOperatingRegions) {
        if (this.addOperatingRegions == null) {
            this.setAddOperatingRegions((Collection<AddIpamOperatingRegion>)new SdkInternalList(addOperatingRegions.length));
        }
        for (AddIpamOperatingRegion ele : addOperatingRegions) {
            this.addOperatingRegions.add((Object)ele);
        }
        return this;
    }

    public ModifyIpamRequest withAddOperatingRegions(Collection<AddIpamOperatingRegion> addOperatingRegions) {
        this.setAddOperatingRegions(addOperatingRegions);
        return this;
    }

    public List<RemoveIpamOperatingRegion> getRemoveOperatingRegions() {
        if (this.removeOperatingRegions == null) {
            this.removeOperatingRegions = new SdkInternalList();
        }
        return this.removeOperatingRegions;
    }

    public void setRemoveOperatingRegions(Collection<RemoveIpamOperatingRegion> removeOperatingRegions) {
        if (removeOperatingRegions == null) {
            this.removeOperatingRegions = null;
            return;
        }
        this.removeOperatingRegions = new SdkInternalList(removeOperatingRegions);
    }

    public ModifyIpamRequest withRemoveOperatingRegions(RemoveIpamOperatingRegion ... removeOperatingRegions) {
        if (this.removeOperatingRegions == null) {
            this.setRemoveOperatingRegions((Collection<RemoveIpamOperatingRegion>)new SdkInternalList(removeOperatingRegions.length));
        }
        for (RemoveIpamOperatingRegion ele : removeOperatingRegions) {
            this.removeOperatingRegions.add((Object)ele);
        }
        return this;
    }

    public ModifyIpamRequest withRemoveOperatingRegions(Collection<RemoveIpamOperatingRegion> removeOperatingRegions) {
        this.setRemoveOperatingRegions(removeOperatingRegions);
        return this;
    }

    public void setTier(String tier) {
        this.tier = tier;
    }

    public String getTier() {
        return this.tier;
    }

    public ModifyIpamRequest withTier(String tier) {
        this.setTier(tier);
        return this;
    }

    public ModifyIpamRequest withTier(IpamTier tier) {
        this.tier = tier.toString();
        return this;
    }

    @Override
    public Request<ModifyIpamRequest> getDryRunRequest() {
        Request<ModifyIpamRequest> request = new ModifyIpamRequestMarshaller().marshall(this);
        request.addParameter("DryRun", Boolean.toString(true));
        return request;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getIpamId() != null) {
            sb.append("IpamId: ").append(this.getIpamId()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getAddOperatingRegions() != null) {
            sb.append("AddOperatingRegions: ").append(this.getAddOperatingRegions()).append(",");
        }
        if (this.getRemoveOperatingRegions() != null) {
            sb.append("RemoveOperatingRegions: ").append(this.getRemoveOperatingRegions()).append(",");
        }
        if (this.getTier() != null) {
            sb.append("Tier: ").append(this.getTier());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyIpamRequest)) {
            return false;
        }
        ModifyIpamRequest other = (ModifyIpamRequest)obj;
        if (other.getIpamId() == null ^ this.getIpamId() == null) {
            return false;
        }
        if (other.getIpamId() != null && !other.getIpamId().equals(this.getIpamId())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getAddOperatingRegions() == null ^ this.getAddOperatingRegions() == null) {
            return false;
        }
        if (other.getAddOperatingRegions() != null && !other.getAddOperatingRegions().equals(this.getAddOperatingRegions())) {
            return false;
        }
        if (other.getRemoveOperatingRegions() == null ^ this.getRemoveOperatingRegions() == null) {
            return false;
        }
        if (other.getRemoveOperatingRegions() != null && !other.getRemoveOperatingRegions().equals(this.getRemoveOperatingRegions())) {
            return false;
        }
        if (other.getTier() == null ^ this.getTier() == null) {
            return false;
        }
        return other.getTier() == null || other.getTier().equals(this.getTier());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getIpamId() == null ? 0 : this.getIpamId().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getAddOperatingRegions() == null ? 0 : this.getAddOperatingRegions().hashCode());
        hashCode = 31 * hashCode + (this.getRemoveOperatingRegions() == null ? 0 : this.getRemoveOperatingRegions().hashCode());
        hashCode = 31 * hashCode + (this.getTier() == null ? 0 : this.getTier().hashCode());
        return hashCode;
    }

    public ModifyIpamRequest clone() {
        return (ModifyIpamRequest)super.clone();
    }
}

