/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.CreateKeyPairRequest;
import com.amazonaws.services.ec2.model.Tag;
import com.amazonaws.services.ec2.model.TagSpecification;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class CreateKeyPairRequestMarshaller
implements Marshaller<Request<CreateKeyPairRequest>, CreateKeyPairRequest> {
    public Request<CreateKeyPairRequest> marshall(CreateKeyPairRequest createKeyPairRequest) {
        SdkInternalList createKeyPairRequestTagSpecificationsList;
        if (createKeyPairRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createKeyPairRequest, "AmazonEC2");
        request.addParameter("Action", "CreateKeyPair");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (createKeyPairRequest.getKeyName() != null) {
            request.addParameter("KeyName", StringUtils.fromString((String)createKeyPairRequest.getKeyName()));
        }
        if (createKeyPairRequest.getKeyType() != null) {
            request.addParameter("KeyType", StringUtils.fromString((String)createKeyPairRequest.getKeyType()));
        }
        if (!(createKeyPairRequestTagSpecificationsList = (SdkInternalList)createKeyPairRequest.getTagSpecifications()).isEmpty() || !createKeyPairRequestTagSpecificationsList.isAutoConstruct()) {
            int tagSpecificationsListIndex = 1;
            for (TagSpecification createKeyPairRequestTagSpecificationsListValue : createKeyPairRequestTagSpecificationsList) {
                SdkInternalList tagSpecificationTagsList;
                if (createKeyPairRequestTagSpecificationsListValue.getResourceType() != null) {
                    request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".ResourceType", StringUtils.fromString((String)createKeyPairRequestTagSpecificationsListValue.getResourceType()));
                }
                if (!(tagSpecificationTagsList = (SdkInternalList)createKeyPairRequestTagSpecificationsListValue.getTags()).isEmpty() || !tagSpecificationTagsList.isAutoConstruct()) {
                    int tagsListIndex = 1;
                    for (Tag tagSpecificationTagsListValue : tagSpecificationTagsList) {
                        if (tagSpecificationTagsListValue.getKey() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Key", StringUtils.fromString((String)tagSpecificationTagsListValue.getKey()));
                        }
                        if (tagSpecificationTagsListValue.getValue() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Value", StringUtils.fromString((String)tagSpecificationTagsListValue.getValue()));
                        }
                        ++tagsListIndex;
                    }
                }
                ++tagSpecificationsListIndex;
            }
        }
        if (createKeyPairRequest.getKeyFormat() != null) {
            request.addParameter("KeyFormat", StringUtils.fromString((String)createKeyPairRequest.getKeyFormat()));
        }
        return request;
    }
}

