/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.CreateVerifiedAccessGroupRequest;
import com.amazonaws.services.ec2.model.Tag;
import com.amazonaws.services.ec2.model.TagSpecification;
import com.amazonaws.services.ec2.model.VerifiedAccessSseSpecificationRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.IdempotentUtils;
import com.amazonaws.util.StringUtils;

public class CreateVerifiedAccessGroupRequestMarshaller
implements Marshaller<Request<CreateVerifiedAccessGroupRequest>, CreateVerifiedAccessGroupRequest> {
    public Request<CreateVerifiedAccessGroupRequest> marshall(CreateVerifiedAccessGroupRequest createVerifiedAccessGroupRequest) {
        SdkInternalList createVerifiedAccessGroupRequestTagSpecificationsList;
        if (createVerifiedAccessGroupRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createVerifiedAccessGroupRequest, "AmazonEC2");
        request.addParameter("Action", "CreateVerifiedAccessGroup");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (createVerifiedAccessGroupRequest.getVerifiedAccessInstanceId() != null) {
            request.addParameter("VerifiedAccessInstanceId", StringUtils.fromString((String)createVerifiedAccessGroupRequest.getVerifiedAccessInstanceId()));
        }
        if (createVerifiedAccessGroupRequest.getDescription() != null) {
            request.addParameter("Description", StringUtils.fromString((String)createVerifiedAccessGroupRequest.getDescription()));
        }
        if (createVerifiedAccessGroupRequest.getPolicyDocument() != null) {
            request.addParameter("PolicyDocument", StringUtils.fromString((String)createVerifiedAccessGroupRequest.getPolicyDocument()));
        }
        if (!(createVerifiedAccessGroupRequestTagSpecificationsList = (SdkInternalList)createVerifiedAccessGroupRequest.getTagSpecifications()).isEmpty() || !createVerifiedAccessGroupRequestTagSpecificationsList.isAutoConstruct()) {
            int tagSpecificationsListIndex = 1;
            for (TagSpecification createVerifiedAccessGroupRequestTagSpecificationsListValue : createVerifiedAccessGroupRequestTagSpecificationsList) {
                SdkInternalList tagSpecificationTagsList;
                if (createVerifiedAccessGroupRequestTagSpecificationsListValue.getResourceType() != null) {
                    request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".ResourceType", StringUtils.fromString((String)createVerifiedAccessGroupRequestTagSpecificationsListValue.getResourceType()));
                }
                if (!(tagSpecificationTagsList = (SdkInternalList)createVerifiedAccessGroupRequestTagSpecificationsListValue.getTags()).isEmpty() || !tagSpecificationTagsList.isAutoConstruct()) {
                    int tagsListIndex = 1;
                    for (Tag tagSpecificationTagsListValue : tagSpecificationTagsList) {
                        if (tagSpecificationTagsListValue.getKey() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Key", StringUtils.fromString((String)tagSpecificationTagsListValue.getKey()));
                        }
                        if (tagSpecificationTagsListValue.getValue() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Value", StringUtils.fromString((String)tagSpecificationTagsListValue.getValue()));
                        }
                        ++tagsListIndex;
                    }
                }
                ++tagSpecificationsListIndex;
            }
        }
        request.addParameter("ClientToken", IdempotentUtils.resolveString((String)createVerifiedAccessGroupRequest.getClientToken()));
        VerifiedAccessSseSpecificationRequest sseSpecification = createVerifiedAccessGroupRequest.getSseSpecification();
        if (sseSpecification != null) {
            if (sseSpecification.getCustomerManagedKeyEnabled() != null) {
                request.addParameter("SseSpecification.CustomerManagedKeyEnabled", StringUtils.fromBoolean((Boolean)sseSpecification.getCustomerManagedKeyEnabled()));
            }
            if (sseSpecification.getKmsKeyArn() != null) {
                request.addParameter("SseSpecification.KmsKeyArn", StringUtils.fromString((String)sseSpecification.getKmsKeyArn()));
            }
        }
        return request;
    }
}

