/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.services.ec2.model.Tag;
import com.amazonaws.services.ec2.model.Vpc;
import com.amazonaws.services.ec2.model.VpcCidrBlockAssociation;
import com.amazonaws.services.ec2.model.VpcIpv6CidrBlockAssociation;
import com.amazonaws.services.ec2.model.transform.TagStaxUnmarshaller;
import com.amazonaws.services.ec2.model.transform.VpcCidrBlockAssociationStaxUnmarshaller;
import com.amazonaws.services.ec2.model.transform.VpcIpv6CidrBlockAssociationStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;

public class VpcStaxUnmarshaller
implements Unmarshaller<Vpc, StaxUnmarshallerContext> {
    private static VpcStaxUnmarshaller instance;

    public Vpc unmarshall(StaxUnmarshallerContext context) throws Exception {
        Vpc vpc = new Vpc();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return vpc;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("cidrBlock", targetDepth)) {
                    vpc.setCidrBlock(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("dhcpOptionsId", targetDepth)) {
                    vpc.setDhcpOptionsId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("state", targetDepth)) {
                    vpc.setState(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("vpcId", targetDepth)) {
                    vpc.setVpcId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ownerId", targetDepth)) {
                    vpc.setOwnerId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("instanceTenancy", targetDepth)) {
                    vpc.setInstanceTenancy(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ipv6CidrBlockAssociationSet", targetDepth)) {
                    vpc.withIpv6CidrBlockAssociationSet(new ArrayList<VpcIpv6CidrBlockAssociation>());
                    continue;
                }
                if (context.testExpression("ipv6CidrBlockAssociationSet/item", targetDepth)) {
                    vpc.withIpv6CidrBlockAssociationSet(VpcIpv6CidrBlockAssociationStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("cidrBlockAssociationSet", targetDepth)) {
                    vpc.withCidrBlockAssociationSet(new ArrayList<VpcCidrBlockAssociation>());
                    continue;
                }
                if (context.testExpression("cidrBlockAssociationSet/item", targetDepth)) {
                    vpc.withCidrBlockAssociationSet(VpcCidrBlockAssociationStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("isDefault", targetDepth)) {
                    vpc.setIsDefault(SimpleTypeStaxUnmarshallers.BooleanStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("tagSet", targetDepth)) {
                    vpc.withTags(new ArrayList<Tag>());
                    continue;
                }
                if (!context.testExpression("tagSet/item", targetDepth)) continue;
                vpc.withTags(TagStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return vpc;
    }

    public static VpcStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new VpcStaxUnmarshaller();
        }
        return instance;
    }
}

