/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.ec2.model.AttachNetworkInterfaceRequest;
import com.amazonaws.services.ec2.model.EnaSrdSpecification;
import com.amazonaws.services.ec2.model.EnaSrdUdpSpecification;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class AttachNetworkInterfaceRequestMarshaller
implements Marshaller<Request<AttachNetworkInterfaceRequest>, AttachNetworkInterfaceRequest> {
    public Request<AttachNetworkInterfaceRequest> marshall(AttachNetworkInterfaceRequest attachNetworkInterfaceRequest) {
        EnaSrdSpecification enaSrdSpecification;
        if (attachNetworkInterfaceRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)attachNetworkInterfaceRequest, "AmazonEC2");
        request.addParameter("Action", "AttachNetworkInterface");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (attachNetworkInterfaceRequest.getDeviceIndex() != null) {
            request.addParameter("DeviceIndex", StringUtils.fromInteger((Integer)attachNetworkInterfaceRequest.getDeviceIndex()));
        }
        if (attachNetworkInterfaceRequest.getInstanceId() != null) {
            request.addParameter("InstanceId", StringUtils.fromString((String)attachNetworkInterfaceRequest.getInstanceId()));
        }
        if (attachNetworkInterfaceRequest.getNetworkInterfaceId() != null) {
            request.addParameter("NetworkInterfaceId", StringUtils.fromString((String)attachNetworkInterfaceRequest.getNetworkInterfaceId()));
        }
        if (attachNetworkInterfaceRequest.getNetworkCardIndex() != null) {
            request.addParameter("NetworkCardIndex", StringUtils.fromInteger((Integer)attachNetworkInterfaceRequest.getNetworkCardIndex()));
        }
        if ((enaSrdSpecification = attachNetworkInterfaceRequest.getEnaSrdSpecification()) != null) {
            EnaSrdUdpSpecification enaSrdUdpSpecification;
            if (enaSrdSpecification.getEnaSrdEnabled() != null) {
                request.addParameter("EnaSrdSpecification.EnaSrdEnabled", StringUtils.fromBoolean((Boolean)enaSrdSpecification.getEnaSrdEnabled()));
            }
            if ((enaSrdUdpSpecification = enaSrdSpecification.getEnaSrdUdpSpecification()) != null && enaSrdUdpSpecification.getEnaSrdUdpEnabled() != null) {
                request.addParameter("EnaSrdSpecification.EnaSrdUdpSpecification.EnaSrdUdpEnabled", StringUtils.fromBoolean((Boolean)enaSrdUdpSpecification.getEnaSrdUdpEnabled()));
            }
        }
        return request;
    }
}

