/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.services.ec2.model.Host;
import com.amazonaws.services.ec2.model.HostInstance;
import com.amazonaws.services.ec2.model.Tag;
import com.amazonaws.services.ec2.model.transform.AvailableCapacityStaxUnmarshaller;
import com.amazonaws.services.ec2.model.transform.HostInstanceStaxUnmarshaller;
import com.amazonaws.services.ec2.model.transform.HostPropertiesStaxUnmarshaller;
import com.amazonaws.services.ec2.model.transform.TagStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;

public class HostStaxUnmarshaller
implements Unmarshaller<Host, StaxUnmarshallerContext> {
    private static HostStaxUnmarshaller instance;

    public Host unmarshall(StaxUnmarshallerContext context) throws Exception {
        Host host = new Host();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return host;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("autoPlacement", targetDepth)) {
                    host.setAutoPlacement(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("availabilityZone", targetDepth)) {
                    host.setAvailabilityZone(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("availableCapacity", targetDepth)) {
                    host.setAvailableCapacity(AvailableCapacityStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("clientToken", targetDepth)) {
                    host.setClientToken(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("hostId", targetDepth)) {
                    host.setHostId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("hostProperties", targetDepth)) {
                    host.setHostProperties(HostPropertiesStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("hostReservationId", targetDepth)) {
                    host.setHostReservationId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("instances", targetDepth)) {
                    host.withInstances(new ArrayList<HostInstance>());
                    continue;
                }
                if (context.testExpression("instances/item", targetDepth)) {
                    host.withInstances(HostInstanceStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("state", targetDepth)) {
                    host.setState(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("allocationTime", targetDepth)) {
                    host.setAllocationTime(SimpleTypeStaxUnmarshallers.DateStaxUnmarshallerFactory.getInstance((String)"iso8601").unmarshall(context));
                    continue;
                }
                if (context.testExpression("releaseTime", targetDepth)) {
                    host.setReleaseTime(SimpleTypeStaxUnmarshallers.DateStaxUnmarshallerFactory.getInstance((String)"iso8601").unmarshall(context));
                    continue;
                }
                if (context.testExpression("tagSet", targetDepth)) {
                    host.withTags(new ArrayList<Tag>());
                    continue;
                }
                if (context.testExpression("tagSet/item", targetDepth)) {
                    host.withTags(TagStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("hostRecovery", targetDepth)) {
                    host.setHostRecovery(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("allowsMultipleInstanceTypes", targetDepth)) {
                    host.setAllowsMultipleInstanceTypes(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ownerId", targetDepth)) {
                    host.setOwnerId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("availabilityZoneId", targetDepth)) {
                    host.setAvailabilityZoneId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("memberOfServiceLinkedResourceGroup", targetDepth)) {
                    host.setMemberOfServiceLinkedResourceGroup(SimpleTypeStaxUnmarshallers.BooleanStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("outpostArn", targetDepth)) {
                    host.setOutpostArn(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("hostMaintenance", targetDepth)) {
                    host.setHostMaintenance(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("assetId", targetDepth)) continue;
                host.setAssetId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return host;
    }

    public static HostStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new HostStaxUnmarshaller();
        }
        return instance;
    }
}

