/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.ec2.model.GetIpamAddressHistoryRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.Date;

public class GetIpamAddressHistoryRequestMarshaller
implements Marshaller<Request<GetIpamAddressHistoryRequest>, GetIpamAddressHistoryRequest> {
    public Request<GetIpamAddressHistoryRequest> marshall(GetIpamAddressHistoryRequest getIpamAddressHistoryRequest) {
        if (getIpamAddressHistoryRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getIpamAddressHistoryRequest, "AmazonEC2");
        request.addParameter("Action", "GetIpamAddressHistory");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (getIpamAddressHistoryRequest.getCidr() != null) {
            request.addParameter("Cidr", StringUtils.fromString((String)getIpamAddressHistoryRequest.getCidr()));
        }
        if (getIpamAddressHistoryRequest.getIpamScopeId() != null) {
            request.addParameter("IpamScopeId", StringUtils.fromString((String)getIpamAddressHistoryRequest.getIpamScopeId()));
        }
        if (getIpamAddressHistoryRequest.getVpcId() != null) {
            request.addParameter("VpcId", StringUtils.fromString((String)getIpamAddressHistoryRequest.getVpcId()));
        }
        if (getIpamAddressHistoryRequest.getStartTime() != null) {
            request.addParameter("StartTime", StringUtils.fromDate((Date)getIpamAddressHistoryRequest.getStartTime()));
        }
        if (getIpamAddressHistoryRequest.getEndTime() != null) {
            request.addParameter("EndTime", StringUtils.fromDate((Date)getIpamAddressHistoryRequest.getEndTime()));
        }
        if (getIpamAddressHistoryRequest.getMaxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger((Integer)getIpamAddressHistoryRequest.getMaxResults()));
        }
        if (getIpamAddressHistoryRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)getIpamAddressHistoryRequest.getNextToken()));
        }
        return request;
    }
}

