/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.CreateSubnetRequest;
import com.amazonaws.services.ec2.model.Tag;
import com.amazonaws.services.ec2.model.TagSpecification;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class CreateSubnetRequestMarshaller
implements Marshaller<Request<CreateSubnetRequest>, CreateSubnetRequest> {
    public Request<CreateSubnetRequest> marshall(CreateSubnetRequest createSubnetRequest) {
        if (createSubnetRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createSubnetRequest, "AmazonEC2");
        request.addParameter("Action", "CreateSubnet");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList createSubnetRequestTagSpecificationsList = (SdkInternalList)createSubnetRequest.getTagSpecifications();
        if (!createSubnetRequestTagSpecificationsList.isEmpty() || !createSubnetRequestTagSpecificationsList.isAutoConstruct()) {
            int tagSpecificationsListIndex = 1;
            for (TagSpecification createSubnetRequestTagSpecificationsListValue : createSubnetRequestTagSpecificationsList) {
                SdkInternalList tagSpecificationTagsList;
                if (createSubnetRequestTagSpecificationsListValue.getResourceType() != null) {
                    request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".ResourceType", StringUtils.fromString((String)createSubnetRequestTagSpecificationsListValue.getResourceType()));
                }
                if (!(tagSpecificationTagsList = (SdkInternalList)createSubnetRequestTagSpecificationsListValue.getTags()).isEmpty() || !tagSpecificationTagsList.isAutoConstruct()) {
                    int tagsListIndex = 1;
                    for (Tag tagSpecificationTagsListValue : tagSpecificationTagsList) {
                        if (tagSpecificationTagsListValue.getKey() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Key", StringUtils.fromString((String)tagSpecificationTagsListValue.getKey()));
                        }
                        if (tagSpecificationTagsListValue.getValue() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Value", StringUtils.fromString((String)tagSpecificationTagsListValue.getValue()));
                        }
                        ++tagsListIndex;
                    }
                }
                ++tagSpecificationsListIndex;
            }
        }
        if (createSubnetRequest.getAvailabilityZone() != null) {
            request.addParameter("AvailabilityZone", StringUtils.fromString((String)createSubnetRequest.getAvailabilityZone()));
        }
        if (createSubnetRequest.getAvailabilityZoneId() != null) {
            request.addParameter("AvailabilityZoneId", StringUtils.fromString((String)createSubnetRequest.getAvailabilityZoneId()));
        }
        if (createSubnetRequest.getCidrBlock() != null) {
            request.addParameter("CidrBlock", StringUtils.fromString((String)createSubnetRequest.getCidrBlock()));
        }
        if (createSubnetRequest.getIpv6CidrBlock() != null) {
            request.addParameter("Ipv6CidrBlock", StringUtils.fromString((String)createSubnetRequest.getIpv6CidrBlock()));
        }
        if (createSubnetRequest.getOutpostArn() != null) {
            request.addParameter("OutpostArn", StringUtils.fromString((String)createSubnetRequest.getOutpostArn()));
        }
        if (createSubnetRequest.getVpcId() != null) {
            request.addParameter("VpcId", StringUtils.fromString((String)createSubnetRequest.getVpcId()));
        }
        if (createSubnetRequest.getIpv6Native() != null) {
            request.addParameter("Ipv6Native", StringUtils.fromBoolean((Boolean)createSubnetRequest.getIpv6Native()));
        }
        if (createSubnetRequest.getIpv4IpamPoolId() != null) {
            request.addParameter("Ipv4IpamPoolId", StringUtils.fromString((String)createSubnetRequest.getIpv4IpamPoolId()));
        }
        if (createSubnetRequest.getIpv4NetmaskLength() != null) {
            request.addParameter("Ipv4NetmaskLength", StringUtils.fromInteger((Integer)createSubnetRequest.getIpv4NetmaskLength()));
        }
        if (createSubnetRequest.getIpv6IpamPoolId() != null) {
            request.addParameter("Ipv6IpamPoolId", StringUtils.fromString((String)createSubnetRequest.getIpv6IpamPoolId()));
        }
        if (createSubnetRequest.getIpv6NetmaskLength() != null) {
            request.addParameter("Ipv6NetmaskLength", StringUtils.fromInteger((Integer)createSubnetRequest.getIpv6NetmaskLength()));
        }
        return request;
    }
}

