/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.ArchitectureType;
import com.amazonaws.services.ec2.model.SupportedAdditionalProcessorFeature;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class ProcessorInfo
implements Serializable,
Cloneable {
    private SdkInternalList<String> supportedArchitectures;
    private Double sustainedClockSpeedInGhz;
    private SdkInternalList<String> supportedFeatures;

    public List<String> getSupportedArchitectures() {
        if (this.supportedArchitectures == null) {
            this.supportedArchitectures = new SdkInternalList();
        }
        return this.supportedArchitectures;
    }

    public void setSupportedArchitectures(Collection<String> supportedArchitectures) {
        if (supportedArchitectures == null) {
            this.supportedArchitectures = null;
            return;
        }
        this.supportedArchitectures = new SdkInternalList(supportedArchitectures);
    }

    public ProcessorInfo withSupportedArchitectures(String ... supportedArchitectures) {
        if (this.supportedArchitectures == null) {
            this.setSupportedArchitectures((Collection<String>)new SdkInternalList(supportedArchitectures.length));
        }
        for (String ele : supportedArchitectures) {
            this.supportedArchitectures.add((Object)ele);
        }
        return this;
    }

    public ProcessorInfo withSupportedArchitectures(Collection<String> supportedArchitectures) {
        this.setSupportedArchitectures(supportedArchitectures);
        return this;
    }

    public ProcessorInfo withSupportedArchitectures(ArchitectureType ... supportedArchitectures) {
        SdkInternalList supportedArchitecturesCopy = new SdkInternalList(supportedArchitectures.length);
        for (ArchitectureType value : supportedArchitectures) {
            supportedArchitecturesCopy.add((Object)value.toString());
        }
        if (this.getSupportedArchitectures() == null) {
            this.setSupportedArchitectures((Collection<String>)supportedArchitecturesCopy);
        } else {
            this.getSupportedArchitectures().addAll((Collection<String>)supportedArchitecturesCopy);
        }
        return this;
    }

    public void setSustainedClockSpeedInGhz(Double sustainedClockSpeedInGhz) {
        this.sustainedClockSpeedInGhz = sustainedClockSpeedInGhz;
    }

    public Double getSustainedClockSpeedInGhz() {
        return this.sustainedClockSpeedInGhz;
    }

    public ProcessorInfo withSustainedClockSpeedInGhz(Double sustainedClockSpeedInGhz) {
        this.setSustainedClockSpeedInGhz(sustainedClockSpeedInGhz);
        return this;
    }

    public List<String> getSupportedFeatures() {
        if (this.supportedFeatures == null) {
            this.supportedFeatures = new SdkInternalList();
        }
        return this.supportedFeatures;
    }

    public void setSupportedFeatures(Collection<String> supportedFeatures) {
        if (supportedFeatures == null) {
            this.supportedFeatures = null;
            return;
        }
        this.supportedFeatures = new SdkInternalList(supportedFeatures);
    }

    public ProcessorInfo withSupportedFeatures(String ... supportedFeatures) {
        if (this.supportedFeatures == null) {
            this.setSupportedFeatures((Collection<String>)new SdkInternalList(supportedFeatures.length));
        }
        for (String ele : supportedFeatures) {
            this.supportedFeatures.add((Object)ele);
        }
        return this;
    }

    public ProcessorInfo withSupportedFeatures(Collection<String> supportedFeatures) {
        this.setSupportedFeatures(supportedFeatures);
        return this;
    }

    public ProcessorInfo withSupportedFeatures(SupportedAdditionalProcessorFeature ... supportedFeatures) {
        SdkInternalList supportedFeaturesCopy = new SdkInternalList(supportedFeatures.length);
        for (SupportedAdditionalProcessorFeature value : supportedFeatures) {
            supportedFeaturesCopy.add((Object)value.toString());
        }
        if (this.getSupportedFeatures() == null) {
            this.setSupportedFeatures((Collection<String>)supportedFeaturesCopy);
        } else {
            this.getSupportedFeatures().addAll((Collection<String>)supportedFeaturesCopy);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSupportedArchitectures() != null) {
            sb.append("SupportedArchitectures: ").append(this.getSupportedArchitectures()).append(",");
        }
        if (this.getSustainedClockSpeedInGhz() != null) {
            sb.append("SustainedClockSpeedInGhz: ").append(this.getSustainedClockSpeedInGhz()).append(",");
        }
        if (this.getSupportedFeatures() != null) {
            sb.append("SupportedFeatures: ").append(this.getSupportedFeatures());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProcessorInfo)) {
            return false;
        }
        ProcessorInfo other = (ProcessorInfo)obj;
        if (other.getSupportedArchitectures() == null ^ this.getSupportedArchitectures() == null) {
            return false;
        }
        if (other.getSupportedArchitectures() != null && !other.getSupportedArchitectures().equals(this.getSupportedArchitectures())) {
            return false;
        }
        if (other.getSustainedClockSpeedInGhz() == null ^ this.getSustainedClockSpeedInGhz() == null) {
            return false;
        }
        if (other.getSustainedClockSpeedInGhz() != null && !other.getSustainedClockSpeedInGhz().equals(this.getSustainedClockSpeedInGhz())) {
            return false;
        }
        if (other.getSupportedFeatures() == null ^ this.getSupportedFeatures() == null) {
            return false;
        }
        return other.getSupportedFeatures() == null || other.getSupportedFeatures().equals(this.getSupportedFeatures());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSupportedArchitectures() == null ? 0 : this.getSupportedArchitectures().hashCode());
        hashCode = 31 * hashCode + (this.getSustainedClockSpeedInGhz() == null ? 0 : this.getSustainedClockSpeedInGhz().hashCode());
        hashCode = 31 * hashCode + (this.getSupportedFeatures() == null ? 0 : this.getSupportedFeatures().hashCode());
        return hashCode;
    }

    public ProcessorInfo clone() {
        try {
            return (ProcessorInfo)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

