/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.ClientData;
import com.amazonaws.services.ec2.model.ImageDiskContainer;
import com.amazonaws.services.ec2.model.ImportImageLicenseConfigurationRequest;
import com.amazonaws.services.ec2.model.ImportImageRequest;
import com.amazonaws.services.ec2.model.Tag;
import com.amazonaws.services.ec2.model.TagSpecification;
import com.amazonaws.services.ec2.model.UserBucket;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.Date;

public class ImportImageRequestMarshaller
implements Marshaller<Request<ImportImageRequest>, ImportImageRequest> {
    public Request<ImportImageRequest> marshall(ImportImageRequest importImageRequest) {
        SdkInternalList importImageRequestTagSpecificationsList;
        SdkInternalList importImageRequestLicenseSpecificationsList;
        SdkInternalList importImageRequestDiskContainersList;
        ClientData clientData;
        if (importImageRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)importImageRequest, "AmazonEC2");
        request.addParameter("Action", "ImportImage");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (importImageRequest.getArchitecture() != null) {
            request.addParameter("Architecture", StringUtils.fromString((String)importImageRequest.getArchitecture()));
        }
        if ((clientData = importImageRequest.getClientData()) != null) {
            if (clientData.getComment() != null) {
                request.addParameter("ClientData.Comment", StringUtils.fromString((String)clientData.getComment()));
            }
            if (clientData.getUploadEnd() != null) {
                request.addParameter("ClientData.UploadEnd", StringUtils.fromDate((Date)clientData.getUploadEnd()));
            }
            if (clientData.getUploadSize() != null) {
                request.addParameter("ClientData.UploadSize", StringUtils.fromDouble((Double)clientData.getUploadSize()));
            }
            if (clientData.getUploadStart() != null) {
                request.addParameter("ClientData.UploadStart", StringUtils.fromDate((Date)clientData.getUploadStart()));
            }
        }
        if (importImageRequest.getClientToken() != null) {
            request.addParameter("ClientToken", StringUtils.fromString((String)importImageRequest.getClientToken()));
        }
        if (importImageRequest.getDescription() != null) {
            request.addParameter("Description", StringUtils.fromString((String)importImageRequest.getDescription()));
        }
        if (!(importImageRequestDiskContainersList = (SdkInternalList)importImageRequest.getDiskContainers()).isEmpty() || !importImageRequestDiskContainersList.isAutoConstruct()) {
            int diskContainersListIndex = 1;
            for (Object importImageRequestDiskContainersListValue : importImageRequestDiskContainersList) {
                UserBucket userBucket;
                if (((ImageDiskContainer)importImageRequestDiskContainersListValue).getDescription() != null) {
                    request.addParameter("DiskContainer." + diskContainersListIndex + ".Description", StringUtils.fromString((String)((ImageDiskContainer)importImageRequestDiskContainersListValue).getDescription()));
                }
                if (((ImageDiskContainer)importImageRequestDiskContainersListValue).getDeviceName() != null) {
                    request.addParameter("DiskContainer." + diskContainersListIndex + ".DeviceName", StringUtils.fromString((String)((ImageDiskContainer)importImageRequestDiskContainersListValue).getDeviceName()));
                }
                if (((ImageDiskContainer)importImageRequestDiskContainersListValue).getFormat() != null) {
                    request.addParameter("DiskContainer." + diskContainersListIndex + ".Format", StringUtils.fromString((String)((ImageDiskContainer)importImageRequestDiskContainersListValue).getFormat()));
                }
                if (((ImageDiskContainer)importImageRequestDiskContainersListValue).getSnapshotId() != null) {
                    request.addParameter("DiskContainer." + diskContainersListIndex + ".SnapshotId", StringUtils.fromString((String)((ImageDiskContainer)importImageRequestDiskContainersListValue).getSnapshotId()));
                }
                if (((ImageDiskContainer)importImageRequestDiskContainersListValue).getUrl() != null) {
                    request.addParameter("DiskContainer." + diskContainersListIndex + ".Url", StringUtils.fromString((String)((ImageDiskContainer)importImageRequestDiskContainersListValue).getUrl()));
                }
                if ((userBucket = ((ImageDiskContainer)importImageRequestDiskContainersListValue).getUserBucket()) != null) {
                    if (userBucket.getS3Bucket() != null) {
                        request.addParameter("DiskContainer." + diskContainersListIndex + ".UserBucket.S3Bucket", StringUtils.fromString((String)userBucket.getS3Bucket()));
                    }
                    if (userBucket.getS3Key() != null) {
                        request.addParameter("DiskContainer." + diskContainersListIndex + ".UserBucket.S3Key", StringUtils.fromString((String)userBucket.getS3Key()));
                    }
                }
                ++diskContainersListIndex;
            }
        }
        if (importImageRequest.getEncrypted() != null) {
            request.addParameter("Encrypted", StringUtils.fromBoolean((Boolean)importImageRequest.getEncrypted()));
        }
        if (importImageRequest.getHypervisor() != null) {
            request.addParameter("Hypervisor", StringUtils.fromString((String)importImageRequest.getHypervisor()));
        }
        if (importImageRequest.getKmsKeyId() != null) {
            request.addParameter("KmsKeyId", StringUtils.fromString((String)importImageRequest.getKmsKeyId()));
        }
        if (importImageRequest.getLicenseType() != null) {
            request.addParameter("LicenseType", StringUtils.fromString((String)importImageRequest.getLicenseType()));
        }
        if (importImageRequest.getPlatform() != null) {
            request.addParameter("Platform", StringUtils.fromString((String)importImageRequest.getPlatform()));
        }
        if (importImageRequest.getRoleName() != null) {
            request.addParameter("RoleName", StringUtils.fromString((String)importImageRequest.getRoleName()));
        }
        if (!(importImageRequestLicenseSpecificationsList = (SdkInternalList)importImageRequest.getLicenseSpecifications()).isEmpty() || !importImageRequestLicenseSpecificationsList.isAutoConstruct()) {
            int licenseSpecificationsListIndex = 1;
            for (ImportImageLicenseConfigurationRequest importImageRequestLicenseSpecificationsListValue : importImageRequestLicenseSpecificationsList) {
                if (importImageRequestLicenseSpecificationsListValue.getLicenseConfigurationArn() != null) {
                    request.addParameter("LicenseSpecifications." + licenseSpecificationsListIndex + ".LicenseConfigurationArn", StringUtils.fromString((String)importImageRequestLicenseSpecificationsListValue.getLicenseConfigurationArn()));
                }
                ++licenseSpecificationsListIndex;
            }
        }
        if (!(importImageRequestTagSpecificationsList = (SdkInternalList)importImageRequest.getTagSpecifications()).isEmpty() || !importImageRequestTagSpecificationsList.isAutoConstruct()) {
            int tagSpecificationsListIndex = 1;
            for (TagSpecification importImageRequestTagSpecificationsListValue : importImageRequestTagSpecificationsList) {
                SdkInternalList tagSpecificationTagsList;
                if (importImageRequestTagSpecificationsListValue.getResourceType() != null) {
                    request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".ResourceType", StringUtils.fromString((String)importImageRequestTagSpecificationsListValue.getResourceType()));
                }
                if (!(tagSpecificationTagsList = (SdkInternalList)importImageRequestTagSpecificationsListValue.getTags()).isEmpty() || !tagSpecificationTagsList.isAutoConstruct()) {
                    int tagsListIndex = 1;
                    for (Tag tagSpecificationTagsListValue : tagSpecificationTagsList) {
                        if (tagSpecificationTagsListValue.getKey() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Key", StringUtils.fromString((String)tagSpecificationTagsListValue.getKey()));
                        }
                        if (tagSpecificationTagsListValue.getValue() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Value", StringUtils.fromString((String)tagSpecificationTagsListValue.getValue()));
                        }
                        ++tagsListIndex;
                    }
                }
                ++tagSpecificationsListIndex;
            }
        }
        if (importImageRequest.getUsageOperation() != null) {
            request.addParameter("UsageOperation", StringUtils.fromString((String)importImageRequest.getUsageOperation()));
        }
        return request;
    }
}

