/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.AllocateIpamPoolCidrRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.IdempotentUtils;
import com.amazonaws.util.StringUtils;

public class AllocateIpamPoolCidrRequestMarshaller
implements Marshaller<Request<AllocateIpamPoolCidrRequest>, AllocateIpamPoolCidrRequest> {
    public Request<AllocateIpamPoolCidrRequest> marshall(AllocateIpamPoolCidrRequest allocateIpamPoolCidrRequest) {
        SdkInternalList allocateIpamPoolCidrRequestDisallowedCidrsList;
        if (allocateIpamPoolCidrRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)allocateIpamPoolCidrRequest, "AmazonEC2");
        request.addParameter("Action", "AllocateIpamPoolCidr");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (allocateIpamPoolCidrRequest.getIpamPoolId() != null) {
            request.addParameter("IpamPoolId", StringUtils.fromString((String)allocateIpamPoolCidrRequest.getIpamPoolId()));
        }
        if (allocateIpamPoolCidrRequest.getCidr() != null) {
            request.addParameter("Cidr", StringUtils.fromString((String)allocateIpamPoolCidrRequest.getCidr()));
        }
        if (allocateIpamPoolCidrRequest.getNetmaskLength() != null) {
            request.addParameter("NetmaskLength", StringUtils.fromInteger((Integer)allocateIpamPoolCidrRequest.getNetmaskLength()));
        }
        request.addParameter("ClientToken", IdempotentUtils.resolveString((String)allocateIpamPoolCidrRequest.getClientToken()));
        if (allocateIpamPoolCidrRequest.getDescription() != null) {
            request.addParameter("Description", StringUtils.fromString((String)allocateIpamPoolCidrRequest.getDescription()));
        }
        if (allocateIpamPoolCidrRequest.getPreviewNextCidr() != null) {
            request.addParameter("PreviewNextCidr", StringUtils.fromBoolean((Boolean)allocateIpamPoolCidrRequest.getPreviewNextCidr()));
        }
        if (!(allocateIpamPoolCidrRequestDisallowedCidrsList = (SdkInternalList)allocateIpamPoolCidrRequest.getDisallowedCidrs()).isEmpty() || !allocateIpamPoolCidrRequestDisallowedCidrsList.isAutoConstruct()) {
            int disallowedCidrsListIndex = 1;
            for (String allocateIpamPoolCidrRequestDisallowedCidrsListValue : allocateIpamPoolCidrRequestDisallowedCidrsList) {
                if (allocateIpamPoolCidrRequestDisallowedCidrsListValue != null) {
                    request.addParameter("DisallowedCidr." + disallowedCidrsListIndex, StringUtils.fromString((String)allocateIpamPoolCidrRequestDisallowedCidrsListValue));
                }
                ++disallowedCidrsListIndex;
            }
        }
        return request;
    }
}

