/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.ConnectivityType;
import com.amazonaws.services.ec2.model.DryRunSupportedRequest;
import com.amazonaws.services.ec2.model.TagSpecification;
import com.amazonaws.services.ec2.model.transform.CreateNatGatewayRequestMarshaller;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class CreateNatGatewayRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable,
DryRunSupportedRequest<CreateNatGatewayRequest> {
    private String allocationId;
    private String clientToken;
    private String subnetId;
    private SdkInternalList<TagSpecification> tagSpecifications;
    private String connectivityType;
    private String privateIpAddress;
    private SdkInternalList<String> secondaryAllocationIds;
    private SdkInternalList<String> secondaryPrivateIpAddresses;
    private Integer secondaryPrivateIpAddressCount;

    public void setAllocationId(String allocationId) {
        this.allocationId = allocationId;
    }

    public String getAllocationId() {
        return this.allocationId;
    }

    public CreateNatGatewayRequest withAllocationId(String allocationId) {
        this.setAllocationId(allocationId);
        return this;
    }

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    public String getClientToken() {
        return this.clientToken;
    }

    public CreateNatGatewayRequest withClientToken(String clientToken) {
        this.setClientToken(clientToken);
        return this;
    }

    public void setSubnetId(String subnetId) {
        this.subnetId = subnetId;
    }

    public String getSubnetId() {
        return this.subnetId;
    }

    public CreateNatGatewayRequest withSubnetId(String subnetId) {
        this.setSubnetId(subnetId);
        return this;
    }

    public List<TagSpecification> getTagSpecifications() {
        if (this.tagSpecifications == null) {
            this.tagSpecifications = new SdkInternalList();
        }
        return this.tagSpecifications;
    }

    public void setTagSpecifications(Collection<TagSpecification> tagSpecifications) {
        if (tagSpecifications == null) {
            this.tagSpecifications = null;
            return;
        }
        this.tagSpecifications = new SdkInternalList(tagSpecifications);
    }

    public CreateNatGatewayRequest withTagSpecifications(TagSpecification ... tagSpecifications) {
        if (this.tagSpecifications == null) {
            this.setTagSpecifications((Collection<TagSpecification>)new SdkInternalList(tagSpecifications.length));
        }
        for (TagSpecification ele : tagSpecifications) {
            this.tagSpecifications.add((Object)ele);
        }
        return this;
    }

    public CreateNatGatewayRequest withTagSpecifications(Collection<TagSpecification> tagSpecifications) {
        this.setTagSpecifications(tagSpecifications);
        return this;
    }

    public void setConnectivityType(String connectivityType) {
        this.connectivityType = connectivityType;
    }

    public String getConnectivityType() {
        return this.connectivityType;
    }

    public CreateNatGatewayRequest withConnectivityType(String connectivityType) {
        this.setConnectivityType(connectivityType);
        return this;
    }

    public CreateNatGatewayRequest withConnectivityType(ConnectivityType connectivityType) {
        this.connectivityType = connectivityType.toString();
        return this;
    }

    public void setPrivateIpAddress(String privateIpAddress) {
        this.privateIpAddress = privateIpAddress;
    }

    public String getPrivateIpAddress() {
        return this.privateIpAddress;
    }

    public CreateNatGatewayRequest withPrivateIpAddress(String privateIpAddress) {
        this.setPrivateIpAddress(privateIpAddress);
        return this;
    }

    public List<String> getSecondaryAllocationIds() {
        if (this.secondaryAllocationIds == null) {
            this.secondaryAllocationIds = new SdkInternalList();
        }
        return this.secondaryAllocationIds;
    }

    public void setSecondaryAllocationIds(Collection<String> secondaryAllocationIds) {
        if (secondaryAllocationIds == null) {
            this.secondaryAllocationIds = null;
            return;
        }
        this.secondaryAllocationIds = new SdkInternalList(secondaryAllocationIds);
    }

    public CreateNatGatewayRequest withSecondaryAllocationIds(String ... secondaryAllocationIds) {
        if (this.secondaryAllocationIds == null) {
            this.setSecondaryAllocationIds((Collection<String>)new SdkInternalList(secondaryAllocationIds.length));
        }
        for (String ele : secondaryAllocationIds) {
            this.secondaryAllocationIds.add((Object)ele);
        }
        return this;
    }

    public CreateNatGatewayRequest withSecondaryAllocationIds(Collection<String> secondaryAllocationIds) {
        this.setSecondaryAllocationIds(secondaryAllocationIds);
        return this;
    }

    public List<String> getSecondaryPrivateIpAddresses() {
        if (this.secondaryPrivateIpAddresses == null) {
            this.secondaryPrivateIpAddresses = new SdkInternalList();
        }
        return this.secondaryPrivateIpAddresses;
    }

    public void setSecondaryPrivateIpAddresses(Collection<String> secondaryPrivateIpAddresses) {
        if (secondaryPrivateIpAddresses == null) {
            this.secondaryPrivateIpAddresses = null;
            return;
        }
        this.secondaryPrivateIpAddresses = new SdkInternalList(secondaryPrivateIpAddresses);
    }

    public CreateNatGatewayRequest withSecondaryPrivateIpAddresses(String ... secondaryPrivateIpAddresses) {
        if (this.secondaryPrivateIpAddresses == null) {
            this.setSecondaryPrivateIpAddresses((Collection<String>)new SdkInternalList(secondaryPrivateIpAddresses.length));
        }
        for (String ele : secondaryPrivateIpAddresses) {
            this.secondaryPrivateIpAddresses.add((Object)ele);
        }
        return this;
    }

    public CreateNatGatewayRequest withSecondaryPrivateIpAddresses(Collection<String> secondaryPrivateIpAddresses) {
        this.setSecondaryPrivateIpAddresses(secondaryPrivateIpAddresses);
        return this;
    }

    public void setSecondaryPrivateIpAddressCount(Integer secondaryPrivateIpAddressCount) {
        this.secondaryPrivateIpAddressCount = secondaryPrivateIpAddressCount;
    }

    public Integer getSecondaryPrivateIpAddressCount() {
        return this.secondaryPrivateIpAddressCount;
    }

    public CreateNatGatewayRequest withSecondaryPrivateIpAddressCount(Integer secondaryPrivateIpAddressCount) {
        this.setSecondaryPrivateIpAddressCount(secondaryPrivateIpAddressCount);
        return this;
    }

    @Override
    public Request<CreateNatGatewayRequest> getDryRunRequest() {
        Request<CreateNatGatewayRequest> request = new CreateNatGatewayRequestMarshaller().marshall(this);
        request.addParameter("DryRun", Boolean.toString(true));
        return request;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAllocationId() != null) {
            sb.append("AllocationId: ").append(this.getAllocationId()).append(",");
        }
        if (this.getClientToken() != null) {
            sb.append("ClientToken: ").append(this.getClientToken()).append(",");
        }
        if (this.getSubnetId() != null) {
            sb.append("SubnetId: ").append(this.getSubnetId()).append(",");
        }
        if (this.getTagSpecifications() != null) {
            sb.append("TagSpecifications: ").append(this.getTagSpecifications()).append(",");
        }
        if (this.getConnectivityType() != null) {
            sb.append("ConnectivityType: ").append(this.getConnectivityType()).append(",");
        }
        if (this.getPrivateIpAddress() != null) {
            sb.append("PrivateIpAddress: ").append(this.getPrivateIpAddress()).append(",");
        }
        if (this.getSecondaryAllocationIds() != null) {
            sb.append("SecondaryAllocationIds: ").append(this.getSecondaryAllocationIds()).append(",");
        }
        if (this.getSecondaryPrivateIpAddresses() != null) {
            sb.append("SecondaryPrivateIpAddresses: ").append(this.getSecondaryPrivateIpAddresses()).append(",");
        }
        if (this.getSecondaryPrivateIpAddressCount() != null) {
            sb.append("SecondaryPrivateIpAddressCount: ").append(this.getSecondaryPrivateIpAddressCount());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateNatGatewayRequest)) {
            return false;
        }
        CreateNatGatewayRequest other = (CreateNatGatewayRequest)obj;
        if (other.getAllocationId() == null ^ this.getAllocationId() == null) {
            return false;
        }
        if (other.getAllocationId() != null && !other.getAllocationId().equals(this.getAllocationId())) {
            return false;
        }
        if (other.getClientToken() == null ^ this.getClientToken() == null) {
            return false;
        }
        if (other.getClientToken() != null && !other.getClientToken().equals(this.getClientToken())) {
            return false;
        }
        if (other.getSubnetId() == null ^ this.getSubnetId() == null) {
            return false;
        }
        if (other.getSubnetId() != null && !other.getSubnetId().equals(this.getSubnetId())) {
            return false;
        }
        if (other.getTagSpecifications() == null ^ this.getTagSpecifications() == null) {
            return false;
        }
        if (other.getTagSpecifications() != null && !other.getTagSpecifications().equals(this.getTagSpecifications())) {
            return false;
        }
        if (other.getConnectivityType() == null ^ this.getConnectivityType() == null) {
            return false;
        }
        if (other.getConnectivityType() != null && !other.getConnectivityType().equals(this.getConnectivityType())) {
            return false;
        }
        if (other.getPrivateIpAddress() == null ^ this.getPrivateIpAddress() == null) {
            return false;
        }
        if (other.getPrivateIpAddress() != null && !other.getPrivateIpAddress().equals(this.getPrivateIpAddress())) {
            return false;
        }
        if (other.getSecondaryAllocationIds() == null ^ this.getSecondaryAllocationIds() == null) {
            return false;
        }
        if (other.getSecondaryAllocationIds() != null && !other.getSecondaryAllocationIds().equals(this.getSecondaryAllocationIds())) {
            return false;
        }
        if (other.getSecondaryPrivateIpAddresses() == null ^ this.getSecondaryPrivateIpAddresses() == null) {
            return false;
        }
        if (other.getSecondaryPrivateIpAddresses() != null && !other.getSecondaryPrivateIpAddresses().equals(this.getSecondaryPrivateIpAddresses())) {
            return false;
        }
        if (other.getSecondaryPrivateIpAddressCount() == null ^ this.getSecondaryPrivateIpAddressCount() == null) {
            return false;
        }
        return other.getSecondaryPrivateIpAddressCount() == null || other.getSecondaryPrivateIpAddressCount().equals(this.getSecondaryPrivateIpAddressCount());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAllocationId() == null ? 0 : this.getAllocationId().hashCode());
        hashCode = 31 * hashCode + (this.getClientToken() == null ? 0 : this.getClientToken().hashCode());
        hashCode = 31 * hashCode + (this.getSubnetId() == null ? 0 : this.getSubnetId().hashCode());
        hashCode = 31 * hashCode + (this.getTagSpecifications() == null ? 0 : this.getTagSpecifications().hashCode());
        hashCode = 31 * hashCode + (this.getConnectivityType() == null ? 0 : this.getConnectivityType().hashCode());
        hashCode = 31 * hashCode + (this.getPrivateIpAddress() == null ? 0 : this.getPrivateIpAddress().hashCode());
        hashCode = 31 * hashCode + (this.getSecondaryAllocationIds() == null ? 0 : this.getSecondaryAllocationIds().hashCode());
        hashCode = 31 * hashCode + (this.getSecondaryPrivateIpAddresses() == null ? 0 : this.getSecondaryPrivateIpAddresses().hashCode());
        hashCode = 31 * hashCode + (this.getSecondaryPrivateIpAddressCount() == null ? 0 : this.getSecondaryPrivateIpAddressCount().hashCode());
        return hashCode;
    }

    public CreateNatGatewayRequest clone() {
        return (CreateNatGatewayRequest)super.clone();
    }
}

