/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DryRunSupportedRequest;
import com.amazonaws.services.ec2.model.TargetConfigurationRequest;
import com.amazonaws.services.ec2.model.transform.AcceptReservedInstancesExchangeQuoteRequestMarshaller;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class AcceptReservedInstancesExchangeQuoteRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable,
DryRunSupportedRequest<AcceptReservedInstancesExchangeQuoteRequest> {
    private SdkInternalList<String> reservedInstanceIds;
    private SdkInternalList<TargetConfigurationRequest> targetConfigurations;

    public List<String> getReservedInstanceIds() {
        if (this.reservedInstanceIds == null) {
            this.reservedInstanceIds = new SdkInternalList();
        }
        return this.reservedInstanceIds;
    }

    public void setReservedInstanceIds(Collection<String> reservedInstanceIds) {
        if (reservedInstanceIds == null) {
            this.reservedInstanceIds = null;
            return;
        }
        this.reservedInstanceIds = new SdkInternalList(reservedInstanceIds);
    }

    public AcceptReservedInstancesExchangeQuoteRequest withReservedInstanceIds(String ... reservedInstanceIds) {
        if (this.reservedInstanceIds == null) {
            this.setReservedInstanceIds((Collection<String>)new SdkInternalList(reservedInstanceIds.length));
        }
        for (String ele : reservedInstanceIds) {
            this.reservedInstanceIds.add((Object)ele);
        }
        return this;
    }

    public AcceptReservedInstancesExchangeQuoteRequest withReservedInstanceIds(Collection<String> reservedInstanceIds) {
        this.setReservedInstanceIds(reservedInstanceIds);
        return this;
    }

    public List<TargetConfigurationRequest> getTargetConfigurations() {
        if (this.targetConfigurations == null) {
            this.targetConfigurations = new SdkInternalList();
        }
        return this.targetConfigurations;
    }

    public void setTargetConfigurations(Collection<TargetConfigurationRequest> targetConfigurations) {
        if (targetConfigurations == null) {
            this.targetConfigurations = null;
            return;
        }
        this.targetConfigurations = new SdkInternalList(targetConfigurations);
    }

    public AcceptReservedInstancesExchangeQuoteRequest withTargetConfigurations(TargetConfigurationRequest ... targetConfigurations) {
        if (this.targetConfigurations == null) {
            this.setTargetConfigurations((Collection<TargetConfigurationRequest>)new SdkInternalList(targetConfigurations.length));
        }
        for (TargetConfigurationRequest ele : targetConfigurations) {
            this.targetConfigurations.add((Object)ele);
        }
        return this;
    }

    public AcceptReservedInstancesExchangeQuoteRequest withTargetConfigurations(Collection<TargetConfigurationRequest> targetConfigurations) {
        this.setTargetConfigurations(targetConfigurations);
        return this;
    }

    @Override
    public Request<AcceptReservedInstancesExchangeQuoteRequest> getDryRunRequest() {
        Request<AcceptReservedInstancesExchangeQuoteRequest> request = new AcceptReservedInstancesExchangeQuoteRequestMarshaller().marshall(this);
        request.addParameter("DryRun", Boolean.toString(true));
        return request;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getReservedInstanceIds() != null) {
            sb.append("ReservedInstanceIds: ").append(this.getReservedInstanceIds()).append(",");
        }
        if (this.getTargetConfigurations() != null) {
            sb.append("TargetConfigurations: ").append(this.getTargetConfigurations());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AcceptReservedInstancesExchangeQuoteRequest)) {
            return false;
        }
        AcceptReservedInstancesExchangeQuoteRequest other = (AcceptReservedInstancesExchangeQuoteRequest)obj;
        if (other.getReservedInstanceIds() == null ^ this.getReservedInstanceIds() == null) {
            return false;
        }
        if (other.getReservedInstanceIds() != null && !other.getReservedInstanceIds().equals(this.getReservedInstanceIds())) {
            return false;
        }
        if (other.getTargetConfigurations() == null ^ this.getTargetConfigurations() == null) {
            return false;
        }
        return other.getTargetConfigurations() == null || other.getTargetConfigurations().equals(this.getTargetConfigurations());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getReservedInstanceIds() == null ? 0 : this.getReservedInstanceIds().hashCode());
        hashCode = 31 * hashCode + (this.getTargetConfigurations() == null ? 0 : this.getTargetConfigurations().hashCode());
        return hashCode;
    }

    public AcceptReservedInstancesExchangeQuoteRequest clone() {
        return (AcceptReservedInstancesExchangeQuoteRequest)super.clone();
    }
}

