/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.FleetLaunchTemplateSpecification;
import com.amazonaws.services.ec2.model.LaunchTemplateConfig;
import com.amazonaws.services.ec2.model.LaunchTemplateOverrides;
import com.amazonaws.services.ec2.model.ModifySpotFleetRequestRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ModifySpotFleetRequestRequestMarshaller
implements Marshaller<Request<ModifySpotFleetRequestRequest>, ModifySpotFleetRequestRequest> {
    public Request<ModifySpotFleetRequestRequest> marshall(ModifySpotFleetRequestRequest modifySpotFleetRequestRequest) {
        SdkInternalList modifySpotFleetRequestRequestLaunchTemplateConfigsList;
        if (modifySpotFleetRequestRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)modifySpotFleetRequestRequest, "AmazonEC2");
        request.addParameter("Action", "ModifySpotFleetRequest");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifySpotFleetRequestRequest.getExcessCapacityTerminationPolicy() != null) {
            request.addParameter("ExcessCapacityTerminationPolicy", StringUtils.fromString((String)modifySpotFleetRequestRequest.getExcessCapacityTerminationPolicy()));
        }
        if (!(modifySpotFleetRequestRequestLaunchTemplateConfigsList = (SdkInternalList)modifySpotFleetRequestRequest.getLaunchTemplateConfigs()).isEmpty() || !modifySpotFleetRequestRequestLaunchTemplateConfigsList.isAutoConstruct()) {
            int launchTemplateConfigsListIndex = 1;
            for (LaunchTemplateConfig modifySpotFleetRequestRequestLaunchTemplateConfigsListValue : modifySpotFleetRequestRequestLaunchTemplateConfigsList) {
                SdkInternalList launchTemplateConfigOverridesList;
                FleetLaunchTemplateSpecification launchTemplateSpecification = modifySpotFleetRequestRequestLaunchTemplateConfigsListValue.getLaunchTemplateSpecification();
                if (launchTemplateSpecification != null) {
                    if (launchTemplateSpecification.getLaunchTemplateId() != null) {
                        request.addParameter("LaunchTemplateConfig." + launchTemplateConfigsListIndex + ".LaunchTemplateSpecification.LaunchTemplateId", StringUtils.fromString((String)launchTemplateSpecification.getLaunchTemplateId()));
                    }
                    if (launchTemplateSpecification.getLaunchTemplateName() != null) {
                        request.addParameter("LaunchTemplateConfig." + launchTemplateConfigsListIndex + ".LaunchTemplateSpecification.LaunchTemplateName", StringUtils.fromString((String)launchTemplateSpecification.getLaunchTemplateName()));
                    }
                    if (launchTemplateSpecification.getVersion() != null) {
                        request.addParameter("LaunchTemplateConfig." + launchTemplateConfigsListIndex + ".LaunchTemplateSpecification.Version", StringUtils.fromString((String)launchTemplateSpecification.getVersion()));
                    }
                }
                if (!(launchTemplateConfigOverridesList = (SdkInternalList)modifySpotFleetRequestRequestLaunchTemplateConfigsListValue.getOverrides()).isEmpty() || !launchTemplateConfigOverridesList.isAutoConstruct()) {
                    int overridesListIndex = 1;
                    for (LaunchTemplateOverrides launchTemplateConfigOverridesListValue : launchTemplateConfigOverridesList) {
                        if (launchTemplateConfigOverridesListValue.getInstanceType() != null) {
                            request.addParameter("LaunchTemplateConfig." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceType", StringUtils.fromString((String)launchTemplateConfigOverridesListValue.getInstanceType()));
                        }
                        if (launchTemplateConfigOverridesListValue.getSpotPrice() != null) {
                            request.addParameter("LaunchTemplateConfig." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".SpotPrice", StringUtils.fromString((String)launchTemplateConfigOverridesListValue.getSpotPrice()));
                        }
                        if (launchTemplateConfigOverridesListValue.getSubnetId() != null) {
                            request.addParameter("LaunchTemplateConfig." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".SubnetId", StringUtils.fromString((String)launchTemplateConfigOverridesListValue.getSubnetId()));
                        }
                        if (launchTemplateConfigOverridesListValue.getAvailabilityZone() != null) {
                            request.addParameter("LaunchTemplateConfig." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".AvailabilityZone", StringUtils.fromString((String)launchTemplateConfigOverridesListValue.getAvailabilityZone()));
                        }
                        if (launchTemplateConfigOverridesListValue.getWeightedCapacity() != null) {
                            request.addParameter("LaunchTemplateConfig." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".WeightedCapacity", StringUtils.fromDouble((Double)launchTemplateConfigOverridesListValue.getWeightedCapacity()));
                        }
                        if (launchTemplateConfigOverridesListValue.getPriority() != null) {
                            request.addParameter("LaunchTemplateConfig." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".Priority", StringUtils.fromDouble((Double)launchTemplateConfigOverridesListValue.getPriority()));
                        }
                        ++overridesListIndex;
                    }
                }
                ++launchTemplateConfigsListIndex;
            }
        }
        if (modifySpotFleetRequestRequest.getSpotFleetRequestId() != null) {
            request.addParameter("SpotFleetRequestId", StringUtils.fromString((String)modifySpotFleetRequestRequest.getSpotFleetRequestId()));
        }
        if (modifySpotFleetRequestRequest.getTargetCapacity() != null) {
            request.addParameter("TargetCapacity", StringUtils.fromInteger((Integer)modifySpotFleetRequestRequest.getTargetCapacity()));
        }
        if (modifySpotFleetRequestRequest.getOnDemandTargetCapacity() != null) {
            request.addParameter("OnDemandTargetCapacity", StringUtils.fromInteger((Integer)modifySpotFleetRequestRequest.getOnDemandTargetCapacity()));
        }
        if (modifySpotFleetRequestRequest.getContext() != null) {
            request.addParameter("Context", StringUtils.fromString((String)modifySpotFleetRequestRequest.getContext()));
        }
        return request;
    }
}

