/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.CreateSubnetCidrReservationRequest;
import com.amazonaws.services.ec2.model.Tag;
import com.amazonaws.services.ec2.model.TagSpecification;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class CreateSubnetCidrReservationRequestMarshaller
implements Marshaller<Request<CreateSubnetCidrReservationRequest>, CreateSubnetCidrReservationRequest> {
    public Request<CreateSubnetCidrReservationRequest> marshall(CreateSubnetCidrReservationRequest createSubnetCidrReservationRequest) {
        if (createSubnetCidrReservationRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createSubnetCidrReservationRequest, "AmazonEC2");
        request.addParameter("Action", "CreateSubnetCidrReservation");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList createSubnetCidrReservationRequestTagSpecificationsList = (SdkInternalList)createSubnetCidrReservationRequest.getTagSpecifications();
        if (!createSubnetCidrReservationRequestTagSpecificationsList.isEmpty() || !createSubnetCidrReservationRequestTagSpecificationsList.isAutoConstruct()) {
            int tagSpecificationsListIndex = 1;
            for (TagSpecification createSubnetCidrReservationRequestTagSpecificationsListValue : createSubnetCidrReservationRequestTagSpecificationsList) {
                SdkInternalList tagSpecificationTagsList;
                if (createSubnetCidrReservationRequestTagSpecificationsListValue.getResourceType() != null) {
                    request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".ResourceType", StringUtils.fromString((String)createSubnetCidrReservationRequestTagSpecificationsListValue.getResourceType()));
                }
                if (!(tagSpecificationTagsList = (SdkInternalList)createSubnetCidrReservationRequestTagSpecificationsListValue.getTags()).isEmpty() || !tagSpecificationTagsList.isAutoConstruct()) {
                    int tagsListIndex = 1;
                    for (Tag tagSpecificationTagsListValue : tagSpecificationTagsList) {
                        if (tagSpecificationTagsListValue.getKey() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Key", StringUtils.fromString((String)tagSpecificationTagsListValue.getKey()));
                        }
                        if (tagSpecificationTagsListValue.getValue() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Value", StringUtils.fromString((String)tagSpecificationTagsListValue.getValue()));
                        }
                        ++tagsListIndex;
                    }
                }
                ++tagSpecificationsListIndex;
            }
        }
        if (createSubnetCidrReservationRequest.getSubnetId() != null) {
            request.addParameter("SubnetId", StringUtils.fromString((String)createSubnetCidrReservationRequest.getSubnetId()));
        }
        if (createSubnetCidrReservationRequest.getCidr() != null) {
            request.addParameter("Cidr", StringUtils.fromString((String)createSubnetCidrReservationRequest.getCidr()));
        }
        if (createSubnetCidrReservationRequest.getReservationType() != null) {
            request.addParameter("ReservationType", StringUtils.fromString((String)createSubnetCidrReservationRequest.getReservationType()));
        }
        if (createSubnetCidrReservationRequest.getDescription() != null) {
            request.addParameter("Description", StringUtils.fromString((String)createSubnetCidrReservationRequest.getDescription()));
        }
        return request;
    }
}

