/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.ec2.model.ReleaseAddressRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ReleaseAddressRequestMarshaller
implements Marshaller<Request<ReleaseAddressRequest>, ReleaseAddressRequest> {
    public Request<ReleaseAddressRequest> marshall(ReleaseAddressRequest releaseAddressRequest) {
        if (releaseAddressRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)releaseAddressRequest, "AmazonEC2");
        request.addParameter("Action", "ReleaseAddress");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (releaseAddressRequest.getAllocationId() != null) {
            request.addParameter("AllocationId", StringUtils.fromString((String)releaseAddressRequest.getAllocationId()));
        }
        if (releaseAddressRequest.getPublicIp() != null) {
            request.addParameter("PublicIp", StringUtils.fromString((String)releaseAddressRequest.getPublicIp()));
        }
        if (releaseAddressRequest.getNetworkBorderGroup() != null) {
            request.addParameter("NetworkBorderGroup", StringUtils.fromString((String)releaseAddressRequest.getNetworkBorderGroup()));
        }
        return request;
    }
}

