/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.services.ec2.model.ProcessorInfo;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;

public class ProcessorInfoStaxUnmarshaller
implements Unmarshaller<ProcessorInfo, StaxUnmarshallerContext> {
    private static ProcessorInfoStaxUnmarshaller instance;

    public ProcessorInfo unmarshall(StaxUnmarshallerContext context) throws Exception {
        ProcessorInfo processorInfo = new ProcessorInfo();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return processorInfo;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("supportedArchitectures", targetDepth)) {
                    processorInfo.withSupportedArchitectures(new ArrayList<String>());
                    continue;
                }
                if (context.testExpression("supportedArchitectures/item", targetDepth)) {
                    processorInfo.withSupportedArchitectures(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("sustainedClockSpeedInGhz", targetDepth)) continue;
                processorInfo.setSustainedClockSpeedInGhz(SimpleTypeStaxUnmarshallers.DoubleStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return processorInfo;
    }

    public static ProcessorInfoStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new ProcessorInfoStaxUnmarshaller();
        }
        return instance;
    }
}

