/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.services.ec2.model.IKEVersionsListValue;
import com.amazonaws.services.ec2.model.Phase1DHGroupNumbersListValue;
import com.amazonaws.services.ec2.model.Phase1EncryptionAlgorithmsListValue;
import com.amazonaws.services.ec2.model.Phase1IntegrityAlgorithmsListValue;
import com.amazonaws.services.ec2.model.Phase2DHGroupNumbersListValue;
import com.amazonaws.services.ec2.model.Phase2EncryptionAlgorithmsListValue;
import com.amazonaws.services.ec2.model.Phase2IntegrityAlgorithmsListValue;
import com.amazonaws.services.ec2.model.TunnelOption;
import com.amazonaws.services.ec2.model.transform.IKEVersionsListValueStaxUnmarshaller;
import com.amazonaws.services.ec2.model.transform.Phase1DHGroupNumbersListValueStaxUnmarshaller;
import com.amazonaws.services.ec2.model.transform.Phase1EncryptionAlgorithmsListValueStaxUnmarshaller;
import com.amazonaws.services.ec2.model.transform.Phase1IntegrityAlgorithmsListValueStaxUnmarshaller;
import com.amazonaws.services.ec2.model.transform.Phase2DHGroupNumbersListValueStaxUnmarshaller;
import com.amazonaws.services.ec2.model.transform.Phase2EncryptionAlgorithmsListValueStaxUnmarshaller;
import com.amazonaws.services.ec2.model.transform.Phase2IntegrityAlgorithmsListValueStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;

public class TunnelOptionStaxUnmarshaller
implements Unmarshaller<TunnelOption, StaxUnmarshallerContext> {
    private static TunnelOptionStaxUnmarshaller instance;

    public TunnelOption unmarshall(StaxUnmarshallerContext context) throws Exception {
        TunnelOption tunnelOption = new TunnelOption();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return tunnelOption;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("outsideIpAddress", targetDepth)) {
                    tunnelOption.setOutsideIpAddress(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("tunnelInsideCidr", targetDepth)) {
                    tunnelOption.setTunnelInsideCidr(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("tunnelInsideIpv6Cidr", targetDepth)) {
                    tunnelOption.setTunnelInsideIpv6Cidr(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("preSharedKey", targetDepth)) {
                    tunnelOption.setPreSharedKey(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("phase1LifetimeSeconds", targetDepth)) {
                    tunnelOption.setPhase1LifetimeSeconds(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("phase2LifetimeSeconds", targetDepth)) {
                    tunnelOption.setPhase2LifetimeSeconds(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("rekeyMarginTimeSeconds", targetDepth)) {
                    tunnelOption.setRekeyMarginTimeSeconds(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("rekeyFuzzPercentage", targetDepth)) {
                    tunnelOption.setRekeyFuzzPercentage(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("replayWindowSize", targetDepth)) {
                    tunnelOption.setReplayWindowSize(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("dpdTimeoutSeconds", targetDepth)) {
                    tunnelOption.setDpdTimeoutSeconds(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("phase1EncryptionAlgorithmSet", targetDepth)) {
                    tunnelOption.withPhase1EncryptionAlgorithms(new ArrayList<Phase1EncryptionAlgorithmsListValue>());
                    continue;
                }
                if (context.testExpression("phase1EncryptionAlgorithmSet/item", targetDepth)) {
                    tunnelOption.withPhase1EncryptionAlgorithms(Phase1EncryptionAlgorithmsListValueStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("phase2EncryptionAlgorithmSet", targetDepth)) {
                    tunnelOption.withPhase2EncryptionAlgorithms(new ArrayList<Phase2EncryptionAlgorithmsListValue>());
                    continue;
                }
                if (context.testExpression("phase2EncryptionAlgorithmSet/item", targetDepth)) {
                    tunnelOption.withPhase2EncryptionAlgorithms(Phase2EncryptionAlgorithmsListValueStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("phase1IntegrityAlgorithmSet", targetDepth)) {
                    tunnelOption.withPhase1IntegrityAlgorithms(new ArrayList<Phase1IntegrityAlgorithmsListValue>());
                    continue;
                }
                if (context.testExpression("phase1IntegrityAlgorithmSet/item", targetDepth)) {
                    tunnelOption.withPhase1IntegrityAlgorithms(Phase1IntegrityAlgorithmsListValueStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("phase2IntegrityAlgorithmSet", targetDepth)) {
                    tunnelOption.withPhase2IntegrityAlgorithms(new ArrayList<Phase2IntegrityAlgorithmsListValue>());
                    continue;
                }
                if (context.testExpression("phase2IntegrityAlgorithmSet/item", targetDepth)) {
                    tunnelOption.withPhase2IntegrityAlgorithms(Phase2IntegrityAlgorithmsListValueStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("phase1DHGroupNumberSet", targetDepth)) {
                    tunnelOption.withPhase1DHGroupNumbers(new ArrayList<Phase1DHGroupNumbersListValue>());
                    continue;
                }
                if (context.testExpression("phase1DHGroupNumberSet/item", targetDepth)) {
                    tunnelOption.withPhase1DHGroupNumbers(Phase1DHGroupNumbersListValueStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("phase2DHGroupNumberSet", targetDepth)) {
                    tunnelOption.withPhase2DHGroupNumbers(new ArrayList<Phase2DHGroupNumbersListValue>());
                    continue;
                }
                if (context.testExpression("phase2DHGroupNumberSet/item", targetDepth)) {
                    tunnelOption.withPhase2DHGroupNumbers(Phase2DHGroupNumbersListValueStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ikeVersionSet", targetDepth)) {
                    tunnelOption.withIkeVersions(new ArrayList<IKEVersionsListValue>());
                    continue;
                }
                if (!context.testExpression("ikeVersionSet/item", targetDepth)) continue;
                tunnelOption.withIkeVersions(IKEVersionsListValueStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return tunnelOption;
    }

    public static TunnelOptionStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new TunnelOptionStaxUnmarshaller();
        }
        return instance;
    }
}

