/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.ec2.model.ReplaceRouteRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ReplaceRouteRequestMarshaller
implements Marshaller<Request<ReplaceRouteRequest>, ReplaceRouteRequest> {
    public Request<ReplaceRouteRequest> marshall(ReplaceRouteRequest replaceRouteRequest) {
        if (replaceRouteRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)replaceRouteRequest, "AmazonEC2");
        request.addParameter("Action", "ReplaceRoute");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (replaceRouteRequest.getDestinationCidrBlock() != null) {
            request.addParameter("DestinationCidrBlock", StringUtils.fromString((String)replaceRouteRequest.getDestinationCidrBlock()));
        }
        if (replaceRouteRequest.getDestinationIpv6CidrBlock() != null) {
            request.addParameter("DestinationIpv6CidrBlock", StringUtils.fromString((String)replaceRouteRequest.getDestinationIpv6CidrBlock()));
        }
        if (replaceRouteRequest.getDestinationPrefixListId() != null) {
            request.addParameter("DestinationPrefixListId", StringUtils.fromString((String)replaceRouteRequest.getDestinationPrefixListId()));
        }
        if (replaceRouteRequest.getEgressOnlyInternetGatewayId() != null) {
            request.addParameter("EgressOnlyInternetGatewayId", StringUtils.fromString((String)replaceRouteRequest.getEgressOnlyInternetGatewayId()));
        }
        if (replaceRouteRequest.getGatewayId() != null) {
            request.addParameter("GatewayId", StringUtils.fromString((String)replaceRouteRequest.getGatewayId()));
        }
        if (replaceRouteRequest.getInstanceId() != null) {
            request.addParameter("InstanceId", StringUtils.fromString((String)replaceRouteRequest.getInstanceId()));
        }
        if (replaceRouteRequest.getLocalTarget() != null) {
            request.addParameter("LocalTarget", StringUtils.fromBoolean((Boolean)replaceRouteRequest.getLocalTarget()));
        }
        if (replaceRouteRequest.getNatGatewayId() != null) {
            request.addParameter("NatGatewayId", StringUtils.fromString((String)replaceRouteRequest.getNatGatewayId()));
        }
        if (replaceRouteRequest.getTransitGatewayId() != null) {
            request.addParameter("TransitGatewayId", StringUtils.fromString((String)replaceRouteRequest.getTransitGatewayId()));
        }
        if (replaceRouteRequest.getLocalGatewayId() != null) {
            request.addParameter("LocalGatewayId", StringUtils.fromString((String)replaceRouteRequest.getLocalGatewayId()));
        }
        if (replaceRouteRequest.getCarrierGatewayId() != null) {
            request.addParameter("CarrierGatewayId", StringUtils.fromString((String)replaceRouteRequest.getCarrierGatewayId()));
        }
        if (replaceRouteRequest.getNetworkInterfaceId() != null) {
            request.addParameter("NetworkInterfaceId", StringUtils.fromString((String)replaceRouteRequest.getNetworkInterfaceId()));
        }
        if (replaceRouteRequest.getRouteTableId() != null) {
            request.addParameter("RouteTableId", StringUtils.fromString((String)replaceRouteRequest.getRouteTableId()));
        }
        if (replaceRouteRequest.getVpcPeeringConnectionId() != null) {
            request.addParameter("VpcPeeringConnectionId", StringUtils.fromString((String)replaceRouteRequest.getVpcPeeringConnectionId()));
        }
        return request;
    }
}

