/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.BlockDeviceMapping;
import com.amazonaws.services.ec2.model.EbsBlockDevice;
import com.amazonaws.services.ec2.model.RegisterImageRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class RegisterImageRequestMarshaller
implements Marshaller<Request<RegisterImageRequest>, RegisterImageRequest> {
    public Request<RegisterImageRequest> marshall(RegisterImageRequest registerImageRequest) {
        SdkInternalList registerImageRequestBillingProductsList;
        SdkInternalList registerImageRequestBlockDeviceMappingsList;
        if (registerImageRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)registerImageRequest, "AmazonEC2");
        request.addParameter("Action", "RegisterImage");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (registerImageRequest.getImageLocation() != null) {
            request.addParameter("ImageLocation", StringUtils.fromString((String)registerImageRequest.getImageLocation()));
        }
        if (registerImageRequest.getArchitecture() != null) {
            request.addParameter("Architecture", StringUtils.fromString((String)registerImageRequest.getArchitecture()));
        }
        if (!(registerImageRequestBlockDeviceMappingsList = (SdkInternalList)registerImageRequest.getBlockDeviceMappings()).isEmpty() || !registerImageRequestBlockDeviceMappingsList.isAutoConstruct()) {
            int blockDeviceMappingsListIndex = 1;
            for (BlockDeviceMapping registerImageRequestBlockDeviceMappingsListValue : registerImageRequestBlockDeviceMappingsList) {
                EbsBlockDevice ebs;
                if (registerImageRequestBlockDeviceMappingsListValue.getDeviceName() != null) {
                    request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".DeviceName", StringUtils.fromString((String)registerImageRequestBlockDeviceMappingsListValue.getDeviceName()));
                }
                if (registerImageRequestBlockDeviceMappingsListValue.getVirtualName() != null) {
                    request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".VirtualName", StringUtils.fromString((String)registerImageRequestBlockDeviceMappingsListValue.getVirtualName()));
                }
                if ((ebs = registerImageRequestBlockDeviceMappingsListValue.getEbs()) != null) {
                    if (ebs.getDeleteOnTermination() != null) {
                        request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.DeleteOnTermination", StringUtils.fromBoolean((Boolean)ebs.getDeleteOnTermination()));
                    }
                    if (ebs.getIops() != null) {
                        request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.Iops", StringUtils.fromInteger((Integer)ebs.getIops()));
                    }
                    if (ebs.getSnapshotId() != null) {
                        request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.SnapshotId", StringUtils.fromString((String)ebs.getSnapshotId()));
                    }
                    if (ebs.getVolumeSize() != null) {
                        request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.VolumeSize", StringUtils.fromInteger((Integer)ebs.getVolumeSize()));
                    }
                    if (ebs.getVolumeType() != null) {
                        request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.VolumeType", StringUtils.fromString((String)ebs.getVolumeType()));
                    }
                    if (ebs.getKmsKeyId() != null) {
                        request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.KmsKeyId", StringUtils.fromString((String)ebs.getKmsKeyId()));
                    }
                    if (ebs.getEncrypted() != null) {
                        request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.Encrypted", StringUtils.fromBoolean((Boolean)ebs.getEncrypted()));
                    }
                }
                if (registerImageRequestBlockDeviceMappingsListValue.getNoDevice() != null) {
                    request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".NoDevice", StringUtils.fromString((String)registerImageRequestBlockDeviceMappingsListValue.getNoDevice()));
                }
                ++blockDeviceMappingsListIndex;
            }
        }
        if (registerImageRequest.getDescription() != null) {
            request.addParameter("Description", StringUtils.fromString((String)registerImageRequest.getDescription()));
        }
        if (registerImageRequest.getEnaSupport() != null) {
            request.addParameter("EnaSupport", StringUtils.fromBoolean((Boolean)registerImageRequest.getEnaSupport()));
        }
        if (registerImageRequest.getKernelId() != null) {
            request.addParameter("KernelId", StringUtils.fromString((String)registerImageRequest.getKernelId()));
        }
        if (registerImageRequest.getName() != null) {
            request.addParameter("Name", StringUtils.fromString((String)registerImageRequest.getName()));
        }
        if (!(registerImageRequestBillingProductsList = (SdkInternalList)registerImageRequest.getBillingProducts()).isEmpty() || !registerImageRequestBillingProductsList.isAutoConstruct()) {
            int billingProductsListIndex = 1;
            for (String registerImageRequestBillingProductsListValue : registerImageRequestBillingProductsList) {
                if (registerImageRequestBillingProductsListValue != null) {
                    request.addParameter("BillingProduct." + billingProductsListIndex, StringUtils.fromString((String)registerImageRequestBillingProductsListValue));
                }
                ++billingProductsListIndex;
            }
        }
        if (registerImageRequest.getRamdiskId() != null) {
            request.addParameter("RamdiskId", StringUtils.fromString((String)registerImageRequest.getRamdiskId()));
        }
        if (registerImageRequest.getRootDeviceName() != null) {
            request.addParameter("RootDeviceName", StringUtils.fromString((String)registerImageRequest.getRootDeviceName()));
        }
        if (registerImageRequest.getSriovNetSupport() != null) {
            request.addParameter("SriovNetSupport", StringUtils.fromString((String)registerImageRequest.getSriovNetSupport()));
        }
        if (registerImageRequest.getVirtualizationType() != null) {
            request.addParameter("VirtualizationType", StringUtils.fromString((String)registerImageRequest.getVirtualizationType()));
        }
        return request;
    }
}

