/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.ec2.model.CreateVpcRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class CreateVpcRequestMarshaller
implements Marshaller<Request<CreateVpcRequest>, CreateVpcRequest> {
    public Request<CreateVpcRequest> marshall(CreateVpcRequest createVpcRequest) {
        if (createVpcRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createVpcRequest, "AmazonEC2");
        request.addParameter("Action", "CreateVpc");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (createVpcRequest.getCidrBlock() != null) {
            request.addParameter("CidrBlock", StringUtils.fromString((String)createVpcRequest.getCidrBlock()));
        }
        if (createVpcRequest.getAmazonProvidedIpv6CidrBlock() != null) {
            request.addParameter("AmazonProvidedIpv6CidrBlock", StringUtils.fromBoolean((Boolean)createVpcRequest.getAmazonProvidedIpv6CidrBlock()));
        }
        if (createVpcRequest.getIpv6Pool() != null) {
            request.addParameter("Ipv6Pool", StringUtils.fromString((String)createVpcRequest.getIpv6Pool()));
        }
        if (createVpcRequest.getIpv6CidrBlock() != null) {
            request.addParameter("Ipv6CidrBlock", StringUtils.fromString((String)createVpcRequest.getIpv6CidrBlock()));
        }
        if (createVpcRequest.getInstanceTenancy() != null) {
            request.addParameter("InstanceTenancy", StringUtils.fromString((String)createVpcRequest.getInstanceTenancy()));
        }
        if (createVpcRequest.getIpv6CidrBlockNetworkBorderGroup() != null) {
            request.addParameter("Ipv6CidrBlockNetworkBorderGroup", StringUtils.fromString((String)createVpcRequest.getIpv6CidrBlockNetworkBorderGroup()));
        }
        return request;
    }
}

