/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.TunnelOption;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class VpnConnectionOptions
implements Serializable,
Cloneable {
    private Boolean enableAcceleration;
    private Boolean staticRoutesOnly;
    private SdkInternalList<TunnelOption> tunnelOptions;

    public void setEnableAcceleration(Boolean enableAcceleration) {
        this.enableAcceleration = enableAcceleration;
    }

    public Boolean getEnableAcceleration() {
        return this.enableAcceleration;
    }

    public VpnConnectionOptions withEnableAcceleration(Boolean enableAcceleration) {
        this.setEnableAcceleration(enableAcceleration);
        return this;
    }

    public Boolean isEnableAcceleration() {
        return this.enableAcceleration;
    }

    public void setStaticRoutesOnly(Boolean staticRoutesOnly) {
        this.staticRoutesOnly = staticRoutesOnly;
    }

    public Boolean getStaticRoutesOnly() {
        return this.staticRoutesOnly;
    }

    public VpnConnectionOptions withStaticRoutesOnly(Boolean staticRoutesOnly) {
        this.setStaticRoutesOnly(staticRoutesOnly);
        return this;
    }

    public Boolean isStaticRoutesOnly() {
        return this.staticRoutesOnly;
    }

    public List<TunnelOption> getTunnelOptions() {
        if (this.tunnelOptions == null) {
            this.tunnelOptions = new SdkInternalList();
        }
        return this.tunnelOptions;
    }

    public void setTunnelOptions(Collection<TunnelOption> tunnelOptions) {
        if (tunnelOptions == null) {
            this.tunnelOptions = null;
            return;
        }
        this.tunnelOptions = new SdkInternalList(tunnelOptions);
    }

    public VpnConnectionOptions withTunnelOptions(TunnelOption ... tunnelOptions) {
        if (this.tunnelOptions == null) {
            this.setTunnelOptions((Collection<TunnelOption>)new SdkInternalList(tunnelOptions.length));
        }
        for (TunnelOption ele : tunnelOptions) {
            this.tunnelOptions.add((Object)ele);
        }
        return this;
    }

    public VpnConnectionOptions withTunnelOptions(Collection<TunnelOption> tunnelOptions) {
        this.setTunnelOptions(tunnelOptions);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getEnableAcceleration() != null) {
            sb.append("EnableAcceleration: ").append(this.getEnableAcceleration()).append(",");
        }
        if (this.getStaticRoutesOnly() != null) {
            sb.append("StaticRoutesOnly: ").append(this.getStaticRoutesOnly()).append(",");
        }
        if (this.getTunnelOptions() != null) {
            sb.append("TunnelOptions: ").append(this.getTunnelOptions());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VpnConnectionOptions)) {
            return false;
        }
        VpnConnectionOptions other = (VpnConnectionOptions)obj;
        if (other.getEnableAcceleration() == null ^ this.getEnableAcceleration() == null) {
            return false;
        }
        if (other.getEnableAcceleration() != null && !other.getEnableAcceleration().equals(this.getEnableAcceleration())) {
            return false;
        }
        if (other.getStaticRoutesOnly() == null ^ this.getStaticRoutesOnly() == null) {
            return false;
        }
        if (other.getStaticRoutesOnly() != null && !other.getStaticRoutesOnly().equals(this.getStaticRoutesOnly())) {
            return false;
        }
        if (other.getTunnelOptions() == null ^ this.getTunnelOptions() == null) {
            return false;
        }
        return other.getTunnelOptions() == null || other.getTunnelOptions().equals(this.getTunnelOptions());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getEnableAcceleration() == null ? 0 : this.getEnableAcceleration().hashCode());
        hashCode = 31 * hashCode + (this.getStaticRoutesOnly() == null ? 0 : this.getStaticRoutesOnly().hashCode());
        hashCode = 31 * hashCode + (this.getTunnelOptions() == null ? 0 : this.getTunnelOptions().hashCode());
        return hashCode;
    }

    public VpnConnectionOptions clone() {
        try {
            return (VpnConnectionOptions)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

