/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DryRunSupportedRequest;
import com.amazonaws.services.ec2.model.transform.ApplySecurityGroupsToClientVpnTargetNetworkRequestMarshaller;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class ApplySecurityGroupsToClientVpnTargetNetworkRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable,
DryRunSupportedRequest<ApplySecurityGroupsToClientVpnTargetNetworkRequest> {
    private String clientVpnEndpointId;
    private String vpcId;
    private SdkInternalList<String> securityGroupIds;

    public void setClientVpnEndpointId(String clientVpnEndpointId) {
        this.clientVpnEndpointId = clientVpnEndpointId;
    }

    public String getClientVpnEndpointId() {
        return this.clientVpnEndpointId;
    }

    public ApplySecurityGroupsToClientVpnTargetNetworkRequest withClientVpnEndpointId(String clientVpnEndpointId) {
        this.setClientVpnEndpointId(clientVpnEndpointId);
        return this;
    }

    public void setVpcId(String vpcId) {
        this.vpcId = vpcId;
    }

    public String getVpcId() {
        return this.vpcId;
    }

    public ApplySecurityGroupsToClientVpnTargetNetworkRequest withVpcId(String vpcId) {
        this.setVpcId(vpcId);
        return this;
    }

    public List<String> getSecurityGroupIds() {
        if (this.securityGroupIds == null) {
            this.securityGroupIds = new SdkInternalList();
        }
        return this.securityGroupIds;
    }

    public void setSecurityGroupIds(Collection<String> securityGroupIds) {
        if (securityGroupIds == null) {
            this.securityGroupIds = null;
            return;
        }
        this.securityGroupIds = new SdkInternalList(securityGroupIds);
    }

    public ApplySecurityGroupsToClientVpnTargetNetworkRequest withSecurityGroupIds(String ... securityGroupIds) {
        if (this.securityGroupIds == null) {
            this.setSecurityGroupIds((Collection<String>)new SdkInternalList(securityGroupIds.length));
        }
        for (String ele : securityGroupIds) {
            this.securityGroupIds.add((Object)ele);
        }
        return this;
    }

    public ApplySecurityGroupsToClientVpnTargetNetworkRequest withSecurityGroupIds(Collection<String> securityGroupIds) {
        this.setSecurityGroupIds(securityGroupIds);
        return this;
    }

    @Override
    public Request<ApplySecurityGroupsToClientVpnTargetNetworkRequest> getDryRunRequest() {
        Request<ApplySecurityGroupsToClientVpnTargetNetworkRequest> request = new ApplySecurityGroupsToClientVpnTargetNetworkRequestMarshaller().marshall(this);
        request.addParameter("DryRun", Boolean.toString(true));
        return request;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getClientVpnEndpointId() != null) {
            sb.append("ClientVpnEndpointId: ").append(this.getClientVpnEndpointId()).append(",");
        }
        if (this.getVpcId() != null) {
            sb.append("VpcId: ").append(this.getVpcId()).append(",");
        }
        if (this.getSecurityGroupIds() != null) {
            sb.append("SecurityGroupIds: ").append(this.getSecurityGroupIds());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplySecurityGroupsToClientVpnTargetNetworkRequest)) {
            return false;
        }
        ApplySecurityGroupsToClientVpnTargetNetworkRequest other = (ApplySecurityGroupsToClientVpnTargetNetworkRequest)obj;
        if (other.getClientVpnEndpointId() == null ^ this.getClientVpnEndpointId() == null) {
            return false;
        }
        if (other.getClientVpnEndpointId() != null && !other.getClientVpnEndpointId().equals(this.getClientVpnEndpointId())) {
            return false;
        }
        if (other.getVpcId() == null ^ this.getVpcId() == null) {
            return false;
        }
        if (other.getVpcId() != null && !other.getVpcId().equals(this.getVpcId())) {
            return false;
        }
        if (other.getSecurityGroupIds() == null ^ this.getSecurityGroupIds() == null) {
            return false;
        }
        return other.getSecurityGroupIds() == null || other.getSecurityGroupIds().equals(this.getSecurityGroupIds());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getClientVpnEndpointId() == null ? 0 : this.getClientVpnEndpointId().hashCode());
        hashCode = 31 * hashCode + (this.getVpcId() == null ? 0 : this.getVpcId().hashCode());
        hashCode = 31 * hashCode + (this.getSecurityGroupIds() == null ? 0 : this.getSecurityGroupIds().hashCode());
        return hashCode;
    }

    public ApplySecurityGroupsToClientVpnTargetNetworkRequest clone() {
        return (ApplySecurityGroupsToClientVpnTargetNetworkRequest)super.clone();
    }
}

