/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DiskImage;
import com.amazonaws.services.ec2.model.DiskImageDetail;
import com.amazonaws.services.ec2.model.ImportInstanceLaunchSpecification;
import com.amazonaws.services.ec2.model.ImportInstanceRequest;
import com.amazonaws.services.ec2.model.Placement;
import com.amazonaws.services.ec2.model.UserData;
import com.amazonaws.services.ec2.model.VolumeDetail;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ImportInstanceRequestMarshaller
implements Marshaller<Request<ImportInstanceRequest>, ImportInstanceRequest> {
    public Request<ImportInstanceRequest> marshall(ImportInstanceRequest importInstanceRequest) {
        ImportInstanceLaunchSpecification launchSpecification;
        SdkInternalList importInstanceRequestDiskImagesList;
        if (importInstanceRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)importInstanceRequest, "AmazonEC2");
        request.addParameter("Action", "ImportInstance");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (importInstanceRequest.getDescription() != null) {
            request.addParameter("Description", StringUtils.fromString((String)importInstanceRequest.getDescription()));
        }
        if (!(importInstanceRequestDiskImagesList = (SdkInternalList)importInstanceRequest.getDiskImages()).isEmpty() || !importInstanceRequestDiskImagesList.isAutoConstruct()) {
            int diskImagesListIndex = 1;
            for (DiskImage importInstanceRequestDiskImagesListValue : importInstanceRequestDiskImagesList) {
                VolumeDetail volume;
                Object image;
                if (importInstanceRequestDiskImagesListValue.getDescription() != null) {
                    request.addParameter("DiskImage." + diskImagesListIndex + ".Description", StringUtils.fromString((String)importInstanceRequestDiskImagesListValue.getDescription()));
                }
                if ((image = importInstanceRequestDiskImagesListValue.getImage()) != null) {
                    if (((DiskImageDetail)image).getBytes() != null) {
                        request.addParameter("DiskImage." + diskImagesListIndex + ".Image.Bytes", StringUtils.fromLong((Long)((DiskImageDetail)image).getBytes()));
                    }
                    if (((DiskImageDetail)image).getFormat() != null) {
                        request.addParameter("DiskImage." + diskImagesListIndex + ".Image.Format", StringUtils.fromString((String)((DiskImageDetail)image).getFormat()));
                    }
                    if (((DiskImageDetail)image).getImportManifestUrl() != null) {
                        request.addParameter("DiskImage." + diskImagesListIndex + ".Image.ImportManifestUrl", StringUtils.fromString((String)((DiskImageDetail)image).getImportManifestUrl()));
                    }
                }
                if ((volume = importInstanceRequestDiskImagesListValue.getVolume()) != null && volume.getSize() != null) {
                    request.addParameter("DiskImage." + diskImagesListIndex + ".Volume.Size", StringUtils.fromLong((Long)volume.getSize()));
                }
                ++diskImagesListIndex;
            }
        }
        if ((launchSpecification = importInstanceRequest.getLaunchSpecification()) != null) {
            UserData userData;
            Placement placement;
            SdkInternalList importInstanceLaunchSpecificationGroupNamesList;
            SdkInternalList importInstanceLaunchSpecificationGroupIdsList;
            if (launchSpecification.getAdditionalInfo() != null) {
                request.addParameter("LaunchSpecification.AdditionalInfo", StringUtils.fromString((String)launchSpecification.getAdditionalInfo()));
            }
            if (launchSpecification.getArchitecture() != null) {
                request.addParameter("LaunchSpecification.Architecture", StringUtils.fromString((String)launchSpecification.getArchitecture()));
            }
            if (!(importInstanceLaunchSpecificationGroupIdsList = (SdkInternalList)launchSpecification.getGroupIds()).isEmpty() || !importInstanceLaunchSpecificationGroupIdsList.isAutoConstruct()) {
                int groupIdsListIndex = 1;
                for (Object importInstanceLaunchSpecificationGroupIdsListValue : importInstanceLaunchSpecificationGroupIdsList) {
                    if (importInstanceLaunchSpecificationGroupIdsListValue != null) {
                        request.addParameter("LaunchSpecification.GroupId." + groupIdsListIndex, StringUtils.fromString((String)importInstanceLaunchSpecificationGroupIdsListValue));
                    }
                    ++groupIdsListIndex;
                }
            }
            if (!(importInstanceLaunchSpecificationGroupNamesList = (SdkInternalList)launchSpecification.getGroupNames()).isEmpty() || !importInstanceLaunchSpecificationGroupNamesList.isAutoConstruct()) {
                int groupNamesListIndex = 1;
                for (String importInstanceLaunchSpecificationGroupNamesListValue : importInstanceLaunchSpecificationGroupNamesList) {
                    if (importInstanceLaunchSpecificationGroupNamesListValue != null) {
                        request.addParameter("LaunchSpecification.GroupName." + groupNamesListIndex, StringUtils.fromString((String)importInstanceLaunchSpecificationGroupNamesListValue));
                    }
                    ++groupNamesListIndex;
                }
            }
            if (launchSpecification.getInstanceInitiatedShutdownBehavior() != null) {
                request.addParameter("LaunchSpecification.InstanceInitiatedShutdownBehavior", StringUtils.fromString((String)launchSpecification.getInstanceInitiatedShutdownBehavior()));
            }
            if (launchSpecification.getInstanceType() != null) {
                request.addParameter("LaunchSpecification.InstanceType", StringUtils.fromString((String)launchSpecification.getInstanceType()));
            }
            if (launchSpecification.getMonitoring() != null) {
                request.addParameter("LaunchSpecification.Monitoring.Enabled", StringUtils.fromBoolean((Boolean)launchSpecification.getMonitoring()));
            }
            if ((placement = launchSpecification.getPlacement()) != null) {
                if (placement.getAvailabilityZone() != null) {
                    request.addParameter("LaunchSpecification.Placement.AvailabilityZone", StringUtils.fromString((String)placement.getAvailabilityZone()));
                }
                if (placement.getAffinity() != null) {
                    request.addParameter("LaunchSpecification.Placement.Affinity", StringUtils.fromString((String)placement.getAffinity()));
                }
                if (placement.getGroupName() != null) {
                    request.addParameter("LaunchSpecification.Placement.GroupName", StringUtils.fromString((String)placement.getGroupName()));
                }
                if (placement.getPartitionNumber() != null) {
                    request.addParameter("LaunchSpecification.Placement.PartitionNumber", StringUtils.fromInteger((Integer)placement.getPartitionNumber()));
                }
                if (placement.getHostId() != null) {
                    request.addParameter("LaunchSpecification.Placement.HostId", StringUtils.fromString((String)placement.getHostId()));
                }
                if (placement.getTenancy() != null) {
                    request.addParameter("LaunchSpecification.Placement.Tenancy", StringUtils.fromString((String)placement.getTenancy()));
                }
                if (placement.getSpreadDomain() != null) {
                    request.addParameter("LaunchSpecification.Placement.SpreadDomain", StringUtils.fromString((String)placement.getSpreadDomain()));
                }
            }
            if (launchSpecification.getPrivateIpAddress() != null) {
                request.addParameter("LaunchSpecification.PrivateIpAddress", StringUtils.fromString((String)launchSpecification.getPrivateIpAddress()));
            }
            if (launchSpecification.getSubnetId() != null) {
                request.addParameter("LaunchSpecification.SubnetId", StringUtils.fromString((String)launchSpecification.getSubnetId()));
            }
            if ((userData = launchSpecification.getUserData()) != null && userData.getData() != null) {
                request.addParameter("LaunchSpecification.UserData.Data", StringUtils.fromString((String)userData.getData()));
            }
        }
        if (importInstanceRequest.getPlatform() != null) {
            request.addParameter("Platform", StringUtils.fromString((String)importInstanceRequest.getPlatform()));
        }
        return request;
    }
}

