/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DryRunSupportedRequest;
import com.amazonaws.services.ec2.model.InstanceCreditSpecificationRequest;
import com.amazonaws.services.ec2.model.transform.ModifyInstanceCreditSpecificationRequestMarshaller;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class ModifyInstanceCreditSpecificationRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable,
DryRunSupportedRequest<ModifyInstanceCreditSpecificationRequest> {
    private String clientToken;
    private SdkInternalList<InstanceCreditSpecificationRequest> instanceCreditSpecifications;

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    public String getClientToken() {
        return this.clientToken;
    }

    public ModifyInstanceCreditSpecificationRequest withClientToken(String clientToken) {
        this.setClientToken(clientToken);
        return this;
    }

    public List<InstanceCreditSpecificationRequest> getInstanceCreditSpecifications() {
        if (this.instanceCreditSpecifications == null) {
            this.instanceCreditSpecifications = new SdkInternalList();
        }
        return this.instanceCreditSpecifications;
    }

    public void setInstanceCreditSpecifications(Collection<InstanceCreditSpecificationRequest> instanceCreditSpecifications) {
        if (instanceCreditSpecifications == null) {
            this.instanceCreditSpecifications = null;
            return;
        }
        this.instanceCreditSpecifications = new SdkInternalList(instanceCreditSpecifications);
    }

    public ModifyInstanceCreditSpecificationRequest withInstanceCreditSpecifications(InstanceCreditSpecificationRequest ... instanceCreditSpecifications) {
        if (this.instanceCreditSpecifications == null) {
            this.setInstanceCreditSpecifications((Collection<InstanceCreditSpecificationRequest>)new SdkInternalList(instanceCreditSpecifications.length));
        }
        for (InstanceCreditSpecificationRequest ele : instanceCreditSpecifications) {
            this.instanceCreditSpecifications.add((Object)ele);
        }
        return this;
    }

    public ModifyInstanceCreditSpecificationRequest withInstanceCreditSpecifications(Collection<InstanceCreditSpecificationRequest> instanceCreditSpecifications) {
        this.setInstanceCreditSpecifications(instanceCreditSpecifications);
        return this;
    }

    @Override
    public Request<ModifyInstanceCreditSpecificationRequest> getDryRunRequest() {
        Request<ModifyInstanceCreditSpecificationRequest> request = new ModifyInstanceCreditSpecificationRequestMarshaller().marshall(this);
        request.addParameter("DryRun", Boolean.toString(true));
        return request;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getClientToken() != null) {
            sb.append("ClientToken: ").append(this.getClientToken()).append(",");
        }
        if (this.getInstanceCreditSpecifications() != null) {
            sb.append("InstanceCreditSpecifications: ").append(this.getInstanceCreditSpecifications());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyInstanceCreditSpecificationRequest)) {
            return false;
        }
        ModifyInstanceCreditSpecificationRequest other = (ModifyInstanceCreditSpecificationRequest)obj;
        if (other.getClientToken() == null ^ this.getClientToken() == null) {
            return false;
        }
        if (other.getClientToken() != null && !other.getClientToken().equals(this.getClientToken())) {
            return false;
        }
        if (other.getInstanceCreditSpecifications() == null ^ this.getInstanceCreditSpecifications() == null) {
            return false;
        }
        return other.getInstanceCreditSpecifications() == null || other.getInstanceCreditSpecifications().equals(this.getInstanceCreditSpecifications());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getClientToken() == null ? 0 : this.getClientToken().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceCreditSpecifications() == null ? 0 : this.getInstanceCreditSpecifications().hashCode());
        return hashCode;
    }

    public ModifyInstanceCreditSpecificationRequest clone() {
        return (ModifyInstanceCreditSpecificationRequest)super.clone();
    }
}

