/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DescribePrefixListsRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribePrefixListsRequestMarshaller
implements Marshaller<Request<DescribePrefixListsRequest>, DescribePrefixListsRequest> {
    public Request<DescribePrefixListsRequest> marshall(DescribePrefixListsRequest describePrefixListsRequest) {
        SdkInternalList describePrefixListsRequestFiltersList;
        if (describePrefixListsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describePrefixListsRequest, "AmazonEC2");
        request.addParameter("Action", "DescribePrefixLists");
        request.addParameter("Version", "2016-09-15");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList describePrefixListsRequestPrefixListIdsList = (SdkInternalList)describePrefixListsRequest.getPrefixListIds();
        if (!describePrefixListsRequestPrefixListIdsList.isEmpty() || !describePrefixListsRequestPrefixListIdsList.isAutoConstruct()) {
            int prefixListIdsListIndex = 1;
            for (String describePrefixListsRequestPrefixListIdsListValue : describePrefixListsRequestPrefixListIdsList) {
                if (describePrefixListsRequestPrefixListIdsListValue != null) {
                    request.addParameter("PrefixListId." + prefixListIdsListIndex, StringUtils.fromString((String)describePrefixListsRequestPrefixListIdsListValue));
                }
                ++prefixListIdsListIndex;
            }
        }
        if (!(describePrefixListsRequestFiltersList = (SdkInternalList)describePrefixListsRequest.getFilters()).isEmpty() || !describePrefixListsRequestFiltersList.isAutoConstruct()) {
            int filtersListIndex = 1;
            for (Filter describePrefixListsRequestFiltersListValue : describePrefixListsRequestFiltersList) {
                SdkInternalList filterValuesList;
                if (describePrefixListsRequestFiltersListValue.getName() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)describePrefixListsRequestFiltersListValue.getName()));
                }
                if (!(filterValuesList = (SdkInternalList)describePrefixListsRequestFiltersListValue.getValues()).isEmpty() || !filterValuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (describePrefixListsRequest.getMaxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger((Integer)describePrefixListsRequest.getMaxResults()));
        }
        if (describePrefixListsRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)describePrefixListsRequest.getNextToken()));
        }
        return request;
    }
}

