/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.ec2.model.BundleInstanceRequest;
import com.amazonaws.services.ec2.model.S3Storage;
import com.amazonaws.services.ec2.model.Storage;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class BundleInstanceRequestMarshaller
implements Marshaller<Request<BundleInstanceRequest>, BundleInstanceRequest> {
    public Request<BundleInstanceRequest> marshall(BundleInstanceRequest bundleInstanceRequest) {
        S3Storage s3;
        Storage storage;
        if (bundleInstanceRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)bundleInstanceRequest, "AmazonEC2");
        request.addParameter("Action", "BundleInstance");
        request.addParameter("Version", "2016-09-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (bundleInstanceRequest.getInstanceId() != null) {
            request.addParameter("InstanceId", StringUtils.fromString((String)bundleInstanceRequest.getInstanceId()));
        }
        if ((storage = bundleInstanceRequest.getStorage()) != null && (s3 = storage.getS3()) != null) {
            if (s3.getBucket() != null) {
                request.addParameter("Storage.S3.Bucket", StringUtils.fromString((String)s3.getBucket()));
            }
            if (s3.getPrefix() != null) {
                request.addParameter("Storage.S3.Prefix", StringUtils.fromString((String)s3.getPrefix()));
            }
            if (s3.getAWSAccessKeyId() != null) {
                request.addParameter("Storage.S3.AWSAccessKeyId", StringUtils.fromString((String)s3.getAWSAccessKeyId()));
            }
            if (s3.getUploadPolicy() != null) {
                request.addParameter("Storage.S3.UploadPolicy", StringUtils.fromString((String)s3.getUploadPolicy()));
            }
            if (s3.getUploadPolicySignature() != null) {
                request.addParameter("Storage.S3.UploadPolicySignature", StringUtils.fromString((String)s3.getUploadPolicySignature()));
            }
        }
        return request;
    }
}

