/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.CreateVolumePermission;
import com.amazonaws.services.ec2.model.CreateVolumePermissionModifications;
import com.amazonaws.services.ec2.model.ModifySnapshotAttributeRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ModifySnapshotAttributeRequestMarshaller
implements Marshaller<Request<ModifySnapshotAttributeRequest>, ModifySnapshotAttributeRequest> {
    public Request<ModifySnapshotAttributeRequest> marshall(ModifySnapshotAttributeRequest modifySnapshotAttributeRequest) {
        CreateVolumePermissionModifications createVolumePermission;
        SdkInternalList modifySnapshotAttributeRequestGroupNamesList;
        SdkInternalList modifySnapshotAttributeRequestUserIdsList;
        if (modifySnapshotAttributeRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)modifySnapshotAttributeRequest, "AmazonEC2");
        request.addParameter("Action", "ModifySnapshotAttribute");
        request.addParameter("Version", "2016-09-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifySnapshotAttributeRequest.getSnapshotId() != null) {
            request.addParameter("SnapshotId", StringUtils.fromString((String)modifySnapshotAttributeRequest.getSnapshotId()));
        }
        if (modifySnapshotAttributeRequest.getAttribute() != null) {
            request.addParameter("Attribute", StringUtils.fromString((String)modifySnapshotAttributeRequest.getAttribute()));
        }
        if (modifySnapshotAttributeRequest.getOperationType() != null) {
            request.addParameter("OperationType", StringUtils.fromString((String)modifySnapshotAttributeRequest.getOperationType()));
        }
        if (!(modifySnapshotAttributeRequestUserIdsList = (SdkInternalList)modifySnapshotAttributeRequest.getUserIds()).isEmpty() || !modifySnapshotAttributeRequestUserIdsList.isAutoConstruct()) {
            int userIdsListIndex = 1;
            for (Object modifySnapshotAttributeRequestUserIdsListValue : modifySnapshotAttributeRequestUserIdsList) {
                if (modifySnapshotAttributeRequestUserIdsListValue != null) {
                    request.addParameter("UserId." + userIdsListIndex, StringUtils.fromString((String)modifySnapshotAttributeRequestUserIdsListValue));
                }
                ++userIdsListIndex;
            }
        }
        if (!(modifySnapshotAttributeRequestGroupNamesList = (SdkInternalList)modifySnapshotAttributeRequest.getGroupNames()).isEmpty() || !modifySnapshotAttributeRequestGroupNamesList.isAutoConstruct()) {
            int groupNamesListIndex = 1;
            for (String modifySnapshotAttributeRequestGroupNamesListValue : modifySnapshotAttributeRequestGroupNamesList) {
                if (modifySnapshotAttributeRequestGroupNamesListValue != null) {
                    request.addParameter("UserGroup." + groupNamesListIndex, StringUtils.fromString((String)modifySnapshotAttributeRequestGroupNamesListValue));
                }
                ++groupNamesListIndex;
            }
        }
        if ((createVolumePermission = modifySnapshotAttributeRequest.getCreateVolumePermission()) != null) {
            SdkInternalList createVolumePermissionModificationsRemoveList;
            SdkInternalList createVolumePermissionModificationsAddList = (SdkInternalList)createVolumePermission.getAdd();
            if (!createVolumePermissionModificationsAddList.isEmpty() || !createVolumePermissionModificationsAddList.isAutoConstruct()) {
                int addListIndex = 1;
                for (CreateVolumePermission createVolumePermissionModificationsAddListValue : createVolumePermissionModificationsAddList) {
                    if (createVolumePermissionModificationsAddListValue.getUserId() != null) {
                        request.addParameter("CreateVolumePermission.Add." + addListIndex + ".UserId", StringUtils.fromString((String)createVolumePermissionModificationsAddListValue.getUserId()));
                    }
                    if (createVolumePermissionModificationsAddListValue.getGroup() != null) {
                        request.addParameter("CreateVolumePermission.Add." + addListIndex + ".Group", StringUtils.fromString((String)createVolumePermissionModificationsAddListValue.getGroup()));
                    }
                    ++addListIndex;
                }
            }
            if (!(createVolumePermissionModificationsRemoveList = (SdkInternalList)createVolumePermission.getRemove()).isEmpty() || !createVolumePermissionModificationsRemoveList.isAutoConstruct()) {
                int removeListIndex = 1;
                for (CreateVolumePermission createVolumePermissionModificationsRemoveListValue : createVolumePermissionModificationsRemoveList) {
                    if (createVolumePermissionModificationsRemoveListValue.getUserId() != null) {
                        request.addParameter("CreateVolumePermission.Remove." + removeListIndex + ".UserId", StringUtils.fromString((String)createVolumePermissionModificationsRemoveListValue.getUserId()));
                    }
                    if (createVolumePermissionModificationsRemoveListValue.getGroup() != null) {
                        request.addParameter("CreateVolumePermission.Remove." + removeListIndex + ".Group", StringUtils.fromString((String)createVolumePermissionModificationsRemoveListValue.getGroup()));
                    }
                    ++removeListIndex;
                }
            }
        }
        return request;
    }
}

