/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.AutoPlacement;
import com.amazonaws.services.ec2.model.DryRunSupportedRequest;
import com.amazonaws.services.ec2.model.transform.ModifyHostsRequestMarshaller;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class ModifyHostsRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable,
DryRunSupportedRequest<ModifyHostsRequest> {
    private SdkInternalList<String> hostIds;
    private String autoPlacement;

    public List<String> getHostIds() {
        if (this.hostIds == null) {
            this.hostIds = new SdkInternalList();
        }
        return this.hostIds;
    }

    public void setHostIds(Collection<String> hostIds) {
        if (hostIds == null) {
            this.hostIds = null;
            return;
        }
        this.hostIds = new SdkInternalList(hostIds);
    }

    public ModifyHostsRequest withHostIds(String ... hostIds) {
        if (this.hostIds == null) {
            this.setHostIds((Collection<String>)new SdkInternalList(hostIds.length));
        }
        for (String ele : hostIds) {
            this.hostIds.add((Object)ele);
        }
        return this;
    }

    public ModifyHostsRequest withHostIds(Collection<String> hostIds) {
        this.setHostIds(hostIds);
        return this;
    }

    public void setAutoPlacement(String autoPlacement) {
        this.autoPlacement = autoPlacement;
    }

    public String getAutoPlacement() {
        return this.autoPlacement;
    }

    public ModifyHostsRequest withAutoPlacement(String autoPlacement) {
        this.setAutoPlacement(autoPlacement);
        return this;
    }

    public void setAutoPlacement(AutoPlacement autoPlacement) {
        this.autoPlacement = autoPlacement.toString();
    }

    public ModifyHostsRequest withAutoPlacement(AutoPlacement autoPlacement) {
        this.setAutoPlacement(autoPlacement);
        return this;
    }

    @Override
    public Request<ModifyHostsRequest> getDryRunRequest() {
        Request<ModifyHostsRequest> request = new ModifyHostsRequestMarshaller().marshall(this);
        request.addParameter("DryRun", Boolean.toString(true));
        return request;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getHostIds() != null) {
            sb.append("HostIds: " + this.getHostIds() + ",");
        }
        if (this.getAutoPlacement() != null) {
            sb.append("AutoPlacement: " + this.getAutoPlacement());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyHostsRequest)) {
            return false;
        }
        ModifyHostsRequest other = (ModifyHostsRequest)obj;
        if (other.getHostIds() == null ^ this.getHostIds() == null) {
            return false;
        }
        if (other.getHostIds() != null && !other.getHostIds().equals(this.getHostIds())) {
            return false;
        }
        if (other.getAutoPlacement() == null ^ this.getAutoPlacement() == null) {
            return false;
        }
        return other.getAutoPlacement() == null || other.getAutoPlacement().equals(this.getAutoPlacement());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getHostIds() == null ? 0 : this.getHostIds().hashCode());
        hashCode = 31 * hashCode + (this.getAutoPlacement() == null ? 0 : this.getAutoPlacement().hashCode());
        return hashCode;
    }

    public ModifyHostsRequest clone() {
        return (ModifyHostsRequest)super.clone();
    }
}

