/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DescribePlacementGroupsRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribePlacementGroupsRequestMarshaller
implements Marshaller<Request<DescribePlacementGroupsRequest>, DescribePlacementGroupsRequest> {
    public Request<DescribePlacementGroupsRequest> marshall(DescribePlacementGroupsRequest describePlacementGroupsRequest) {
        SdkInternalList describePlacementGroupsRequestFiltersList;
        if (describePlacementGroupsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describePlacementGroupsRequest, "AmazonEC2");
        request.addParameter("Action", "DescribePlacementGroups");
        request.addParameter("Version", "2016-09-15");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList describePlacementGroupsRequestGroupNamesList = (SdkInternalList)describePlacementGroupsRequest.getGroupNames();
        if (!describePlacementGroupsRequestGroupNamesList.isEmpty() || !describePlacementGroupsRequestGroupNamesList.isAutoConstruct()) {
            int groupNamesListIndex = 1;
            for (String describePlacementGroupsRequestGroupNamesListValue : describePlacementGroupsRequestGroupNamesList) {
                if (describePlacementGroupsRequestGroupNamesListValue != null) {
                    request.addParameter("GroupName." + groupNamesListIndex, StringUtils.fromString((String)describePlacementGroupsRequestGroupNamesListValue));
                }
                ++groupNamesListIndex;
            }
        }
        if (!(describePlacementGroupsRequestFiltersList = (SdkInternalList)describePlacementGroupsRequest.getFilters()).isEmpty() || !describePlacementGroupsRequestFiltersList.isAutoConstruct()) {
            int filtersListIndex = 1;
            for (Filter describePlacementGroupsRequestFiltersListValue : describePlacementGroupsRequestFiltersList) {
                SdkInternalList filterValuesList;
                if (describePlacementGroupsRequestFiltersListValue.getName() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)describePlacementGroupsRequestFiltersListValue.getName()));
                }
                if (!(filterValuesList = (SdkInternalList)describePlacementGroupsRequestFiltersListValue.getValues()).isEmpty() || !filterValuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        return request;
    }
}

