/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DescribeClassicLinkInstancesRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeClassicLinkInstancesRequestMarshaller
implements Marshaller<Request<DescribeClassicLinkInstancesRequest>, DescribeClassicLinkInstancesRequest> {
    public Request<DescribeClassicLinkInstancesRequest> marshall(DescribeClassicLinkInstancesRequest describeClassicLinkInstancesRequest) {
        SdkInternalList describeClassicLinkInstancesRequestFiltersList;
        if (describeClassicLinkInstancesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeClassicLinkInstancesRequest, "AmazonEC2");
        request.addParameter("Action", "DescribeClassicLinkInstances");
        request.addParameter("Version", "2016-09-15");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList describeClassicLinkInstancesRequestInstanceIdsList = (SdkInternalList)describeClassicLinkInstancesRequest.getInstanceIds();
        if (!describeClassicLinkInstancesRequestInstanceIdsList.isEmpty() || !describeClassicLinkInstancesRequestInstanceIdsList.isAutoConstruct()) {
            int instanceIdsListIndex = 1;
            for (String describeClassicLinkInstancesRequestInstanceIdsListValue : describeClassicLinkInstancesRequestInstanceIdsList) {
                if (describeClassicLinkInstancesRequestInstanceIdsListValue != null) {
                    request.addParameter("InstanceId." + instanceIdsListIndex, StringUtils.fromString((String)describeClassicLinkInstancesRequestInstanceIdsListValue));
                }
                ++instanceIdsListIndex;
            }
        }
        if (!(describeClassicLinkInstancesRequestFiltersList = (SdkInternalList)describeClassicLinkInstancesRequest.getFilters()).isEmpty() || !describeClassicLinkInstancesRequestFiltersList.isAutoConstruct()) {
            int filtersListIndex = 1;
            for (Filter describeClassicLinkInstancesRequestFiltersListValue : describeClassicLinkInstancesRequestFiltersList) {
                SdkInternalList filterValuesList;
                if (describeClassicLinkInstancesRequestFiltersListValue.getName() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)describeClassicLinkInstancesRequestFiltersListValue.getName()));
                }
                if (!(filterValuesList = (SdkInternalList)describeClassicLinkInstancesRequestFiltersListValue.getValues()).isEmpty() || !filterValuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (describeClassicLinkInstancesRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)describeClassicLinkInstancesRequest.getNextToken()));
        }
        if (describeClassicLinkInstancesRequest.getMaxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger((Integer)describeClassicLinkInstancesRequest.getMaxResults()));
        }
        return request;
    }
}

