/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.IpPermission;
import com.amazonaws.services.ec2.model.PrefixListId;
import com.amazonaws.services.ec2.model.RevokeSecurityGroupEgressRequest;
import com.amazonaws.services.ec2.model.UserIdGroupPair;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class RevokeSecurityGroupEgressRequestMarshaller
implements Marshaller<Request<RevokeSecurityGroupEgressRequest>, RevokeSecurityGroupEgressRequest> {
    public Request<RevokeSecurityGroupEgressRequest> marshall(RevokeSecurityGroupEgressRequest revokeSecurityGroupEgressRequest) {
        SdkInternalList revokeSecurityGroupEgressRequestIpPermissionsList;
        if (revokeSecurityGroupEgressRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)revokeSecurityGroupEgressRequest, "AmazonEC2");
        request.addParameter("Action", "RevokeSecurityGroupEgress");
        request.addParameter("Version", "2016-09-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (revokeSecurityGroupEgressRequest.getGroupId() != null) {
            request.addParameter("GroupId", StringUtils.fromString((String)revokeSecurityGroupEgressRequest.getGroupId()));
        }
        if (revokeSecurityGroupEgressRequest.getSourceSecurityGroupName() != null) {
            request.addParameter("SourceSecurityGroupName", StringUtils.fromString((String)revokeSecurityGroupEgressRequest.getSourceSecurityGroupName()));
        }
        if (revokeSecurityGroupEgressRequest.getSourceSecurityGroupOwnerId() != null) {
            request.addParameter("SourceSecurityGroupOwnerId", StringUtils.fromString((String)revokeSecurityGroupEgressRequest.getSourceSecurityGroupOwnerId()));
        }
        if (revokeSecurityGroupEgressRequest.getIpProtocol() != null) {
            request.addParameter("IpProtocol", StringUtils.fromString((String)revokeSecurityGroupEgressRequest.getIpProtocol()));
        }
        if (revokeSecurityGroupEgressRequest.getFromPort() != null) {
            request.addParameter("FromPort", StringUtils.fromInteger((Integer)revokeSecurityGroupEgressRequest.getFromPort()));
        }
        if (revokeSecurityGroupEgressRequest.getToPort() != null) {
            request.addParameter("ToPort", StringUtils.fromInteger((Integer)revokeSecurityGroupEgressRequest.getToPort()));
        }
        if (revokeSecurityGroupEgressRequest.getCidrIp() != null) {
            request.addParameter("CidrIp", StringUtils.fromString((String)revokeSecurityGroupEgressRequest.getCidrIp()));
        }
        if (!(revokeSecurityGroupEgressRequestIpPermissionsList = (SdkInternalList)revokeSecurityGroupEgressRequest.getIpPermissions()).isEmpty() || !revokeSecurityGroupEgressRequestIpPermissionsList.isAutoConstruct()) {
            int ipPermissionsListIndex = 1;
            for (IpPermission revokeSecurityGroupEgressRequestIpPermissionsListValue : revokeSecurityGroupEgressRequestIpPermissionsList) {
                SdkInternalList ipPermissionPrefixListIdsList;
                SdkInternalList ipPermissionIpRangesList;
                SdkInternalList ipPermissionUserIdGroupPairsList;
                if (revokeSecurityGroupEgressRequestIpPermissionsListValue.getIpProtocol() != null) {
                    request.addParameter("IpPermissions." + ipPermissionsListIndex + ".IpProtocol", StringUtils.fromString((String)revokeSecurityGroupEgressRequestIpPermissionsListValue.getIpProtocol()));
                }
                if (revokeSecurityGroupEgressRequestIpPermissionsListValue.getFromPort() != null) {
                    request.addParameter("IpPermissions." + ipPermissionsListIndex + ".FromPort", StringUtils.fromInteger((Integer)revokeSecurityGroupEgressRequestIpPermissionsListValue.getFromPort()));
                }
                if (revokeSecurityGroupEgressRequestIpPermissionsListValue.getToPort() != null) {
                    request.addParameter("IpPermissions." + ipPermissionsListIndex + ".ToPort", StringUtils.fromInteger((Integer)revokeSecurityGroupEgressRequestIpPermissionsListValue.getToPort()));
                }
                if (!(ipPermissionUserIdGroupPairsList = (SdkInternalList)revokeSecurityGroupEgressRequestIpPermissionsListValue.getUserIdGroupPairs()).isEmpty() || !ipPermissionUserIdGroupPairsList.isAutoConstruct()) {
                    int userIdGroupPairsListIndex = 1;
                    for (Object ipPermissionUserIdGroupPairsListValue : ipPermissionUserIdGroupPairsList) {
                        if (((UserIdGroupPair)ipPermissionUserIdGroupPairsListValue).getUserId() != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".Groups." + userIdGroupPairsListIndex + ".UserId", StringUtils.fromString((String)((UserIdGroupPair)ipPermissionUserIdGroupPairsListValue).getUserId()));
                        }
                        if (((UserIdGroupPair)ipPermissionUserIdGroupPairsListValue).getGroupName() != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".Groups." + userIdGroupPairsListIndex + ".GroupName", StringUtils.fromString((String)((UserIdGroupPair)ipPermissionUserIdGroupPairsListValue).getGroupName()));
                        }
                        if (((UserIdGroupPair)ipPermissionUserIdGroupPairsListValue).getGroupId() != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".Groups." + userIdGroupPairsListIndex + ".GroupId", StringUtils.fromString((String)((UserIdGroupPair)ipPermissionUserIdGroupPairsListValue).getGroupId()));
                        }
                        if (((UserIdGroupPair)ipPermissionUserIdGroupPairsListValue).getVpcId() != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".Groups." + userIdGroupPairsListIndex + ".VpcId", StringUtils.fromString((String)((UserIdGroupPair)ipPermissionUserIdGroupPairsListValue).getVpcId()));
                        }
                        if (((UserIdGroupPair)ipPermissionUserIdGroupPairsListValue).getVpcPeeringConnectionId() != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".Groups." + userIdGroupPairsListIndex + ".VpcPeeringConnectionId", StringUtils.fromString((String)((UserIdGroupPair)ipPermissionUserIdGroupPairsListValue).getVpcPeeringConnectionId()));
                        }
                        if (((UserIdGroupPair)ipPermissionUserIdGroupPairsListValue).getPeeringStatus() != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".Groups." + userIdGroupPairsListIndex + ".PeeringStatus", StringUtils.fromString((String)((UserIdGroupPair)ipPermissionUserIdGroupPairsListValue).getPeeringStatus()));
                        }
                        ++userIdGroupPairsListIndex;
                    }
                }
                if (!(ipPermissionIpRangesList = (SdkInternalList)revokeSecurityGroupEgressRequestIpPermissionsListValue.getIpRanges()).isEmpty() || !ipPermissionIpRangesList.isAutoConstruct()) {
                    Object ipPermissionUserIdGroupPairsListValue;
                    int ipRangesListIndex = 1;
                    ipPermissionUserIdGroupPairsListValue = ipPermissionIpRangesList.iterator();
                    while (ipPermissionUserIdGroupPairsListValue.hasNext()) {
                        String ipPermissionIpRangesListValue = (String)ipPermissionUserIdGroupPairsListValue.next();
                        if (ipPermissionIpRangesListValue != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".IpRanges." + ipRangesListIndex + ".CidrIp", StringUtils.fromString((String)ipPermissionIpRangesListValue));
                        }
                        ++ipRangesListIndex;
                    }
                }
                if (!(ipPermissionPrefixListIdsList = (SdkInternalList)revokeSecurityGroupEgressRequestIpPermissionsListValue.getPrefixListIds()).isEmpty() || !ipPermissionPrefixListIdsList.isAutoConstruct()) {
                    int prefixListIdsListIndex = 1;
                    for (PrefixListId ipPermissionPrefixListIdsListValue : ipPermissionPrefixListIdsList) {
                        if (ipPermissionPrefixListIdsListValue.getPrefixListId() != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".PrefixListIds." + prefixListIdsListIndex + ".PrefixListId", StringUtils.fromString((String)ipPermissionPrefixListIdsListValue.getPrefixListId()));
                        }
                        ++prefixListIdsListIndex;
                    }
                }
                ++ipPermissionsListIndex;
            }
        }
        return request;
    }
}

