/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.BlockDeviceMapping;
import com.amazonaws.services.ec2.model.EbsBlockDevice;
import com.amazonaws.services.ec2.model.GroupIdentifier;
import com.amazonaws.services.ec2.model.IamInstanceProfileSpecification;
import com.amazonaws.services.ec2.model.InstanceNetworkInterfaceSpecification;
import com.amazonaws.services.ec2.model.LaunchSpecification;
import com.amazonaws.services.ec2.model.PrivateIpAddressSpecification;
import com.amazonaws.services.ec2.model.RequestSpotInstancesRequest;
import com.amazonaws.services.ec2.model.SpotPlacement;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.Date;
import java.util.Iterator;

public class RequestSpotInstancesRequestMarshaller
implements Marshaller<Request<RequestSpotInstancesRequest>, RequestSpotInstancesRequest> {
    public Request<RequestSpotInstancesRequest> marshall(RequestSpotInstancesRequest requestSpotInstancesRequest) {
        LaunchSpecification launchSpecification;
        if (requestSpotInstancesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)requestSpotInstancesRequest, "AmazonEC2");
        request.addParameter("Action", "RequestSpotInstances");
        request.addParameter("Version", "2016-09-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (requestSpotInstancesRequest.getSpotPrice() != null) {
            request.addParameter("SpotPrice", StringUtils.fromString((String)requestSpotInstancesRequest.getSpotPrice()));
        }
        if (requestSpotInstancesRequest.getClientToken() != null) {
            request.addParameter("ClientToken", StringUtils.fromString((String)requestSpotInstancesRequest.getClientToken()));
        }
        if (requestSpotInstancesRequest.getInstanceCount() != null) {
            request.addParameter("InstanceCount", StringUtils.fromInteger((Integer)requestSpotInstancesRequest.getInstanceCount()));
        }
        if (requestSpotInstancesRequest.getType() != null) {
            request.addParameter("Type", StringUtils.fromString((String)requestSpotInstancesRequest.getType()));
        }
        if (requestSpotInstancesRequest.getValidFrom() != null) {
            request.addParameter("ValidFrom", StringUtils.fromDate((Date)requestSpotInstancesRequest.getValidFrom()));
        }
        if (requestSpotInstancesRequest.getValidUntil() != null) {
            request.addParameter("ValidUntil", StringUtils.fromDate((Date)requestSpotInstancesRequest.getValidUntil()));
        }
        if (requestSpotInstancesRequest.getLaunchGroup() != null) {
            request.addParameter("LaunchGroup", StringUtils.fromString((String)requestSpotInstancesRequest.getLaunchGroup()));
        }
        if (requestSpotInstancesRequest.getAvailabilityZoneGroup() != null) {
            request.addParameter("AvailabilityZoneGroup", StringUtils.fromString((String)requestSpotInstancesRequest.getAvailabilityZoneGroup()));
        }
        if (requestSpotInstancesRequest.getBlockDurationMinutes() != null) {
            request.addParameter("BlockDurationMinutes", StringUtils.fromInteger((Integer)requestSpotInstancesRequest.getBlockDurationMinutes()));
        }
        if ((launchSpecification = requestSpotInstancesRequest.getLaunchSpecification()) != null) {
            SdkInternalList securityGroupsList;
            SdkInternalList allSecurityGroupsList;
            IamInstanceProfileSpecification iamInstanceProfile;
            SdkInternalList networkInterfacesList;
            SdkInternalList blockDeviceMappingsList;
            SpotPlacement placement;
            if (launchSpecification.getImageId() != null) {
                request.addParameter("LaunchSpecification.ImageId", StringUtils.fromString((String)launchSpecification.getImageId()));
            }
            if (launchSpecification.getKeyName() != null) {
                request.addParameter("LaunchSpecification.KeyName", StringUtils.fromString((String)launchSpecification.getKeyName()));
            }
            if (launchSpecification.getUserData() != null) {
                request.addParameter("LaunchSpecification.UserData", StringUtils.fromString((String)launchSpecification.getUserData()));
            }
            if (launchSpecification.getAddressingType() != null) {
                request.addParameter("LaunchSpecification.AddressingType", StringUtils.fromString((String)launchSpecification.getAddressingType()));
            }
            if (launchSpecification.getInstanceType() != null) {
                request.addParameter("LaunchSpecification.InstanceType", StringUtils.fromString((String)launchSpecification.getInstanceType()));
            }
            if ((placement = launchSpecification.getPlacement()) != null) {
                if (placement.getAvailabilityZone() != null) {
                    request.addParameter("LaunchSpecification.Placement.AvailabilityZone", StringUtils.fromString((String)placement.getAvailabilityZone()));
                }
                if (placement.getGroupName() != null) {
                    request.addParameter("LaunchSpecification.Placement.GroupName", StringUtils.fromString((String)placement.getGroupName()));
                }
            }
            if (launchSpecification.getKernelId() != null) {
                request.addParameter("LaunchSpecification.KernelId", StringUtils.fromString((String)launchSpecification.getKernelId()));
            }
            if (launchSpecification.getRamdiskId() != null) {
                request.addParameter("LaunchSpecification.RamdiskId", StringUtils.fromString((String)launchSpecification.getRamdiskId()));
            }
            if (!(blockDeviceMappingsList = (SdkInternalList)launchSpecification.getBlockDeviceMappings()).isEmpty() || !blockDeviceMappingsList.isAutoConstruct()) {
                int blockDeviceMappingsListIndex = 1;
                for (Object blockDeviceMappingsListValue : blockDeviceMappingsList) {
                    EbsBlockDevice ebs;
                    if (((BlockDeviceMapping)blockDeviceMappingsListValue).getVirtualName() != null) {
                        request.addParameter("LaunchSpecification.BlockDeviceMapping." + blockDeviceMappingsListIndex + ".VirtualName", StringUtils.fromString((String)((BlockDeviceMapping)blockDeviceMappingsListValue).getVirtualName()));
                    }
                    if (((BlockDeviceMapping)blockDeviceMappingsListValue).getDeviceName() != null) {
                        request.addParameter("LaunchSpecification.BlockDeviceMapping." + blockDeviceMappingsListIndex + ".DeviceName", StringUtils.fromString((String)((BlockDeviceMapping)blockDeviceMappingsListValue).getDeviceName()));
                    }
                    if ((ebs = ((BlockDeviceMapping)blockDeviceMappingsListValue).getEbs()) != null) {
                        if (ebs.getSnapshotId() != null) {
                            request.addParameter("LaunchSpecification.BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.SnapshotId", StringUtils.fromString((String)ebs.getSnapshotId()));
                        }
                        if (ebs.getVolumeSize() != null) {
                            request.addParameter("LaunchSpecification.BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.VolumeSize", StringUtils.fromInteger((Integer)ebs.getVolumeSize()));
                        }
                        if (ebs.getDeleteOnTermination() != null) {
                            request.addParameter("LaunchSpecification.BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.DeleteOnTermination", StringUtils.fromBoolean((Boolean)ebs.getDeleteOnTermination()));
                        }
                        if (ebs.getVolumeType() != null) {
                            request.addParameter("LaunchSpecification.BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.VolumeType", StringUtils.fromString((String)ebs.getVolumeType()));
                        }
                        if (ebs.getIops() != null) {
                            request.addParameter("LaunchSpecification.BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.Iops", StringUtils.fromInteger((Integer)ebs.getIops()));
                        }
                        if (ebs.getEncrypted() != null) {
                            request.addParameter("LaunchSpecification.BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.Encrypted", StringUtils.fromBoolean((Boolean)ebs.getEncrypted()));
                        }
                    }
                    if (((BlockDeviceMapping)blockDeviceMappingsListValue).getNoDevice() != null) {
                        request.addParameter("LaunchSpecification.BlockDeviceMapping." + blockDeviceMappingsListIndex + ".NoDevice", StringUtils.fromString((String)((BlockDeviceMapping)blockDeviceMappingsListValue).getNoDevice()));
                    }
                    ++blockDeviceMappingsListIndex;
                }
            }
            if (launchSpecification.getSubnetId() != null) {
                request.addParameter("LaunchSpecification.SubnetId", StringUtils.fromString((String)launchSpecification.getSubnetId()));
            }
            if (!(networkInterfacesList = (SdkInternalList)launchSpecification.getNetworkInterfaces()).isEmpty() || !networkInterfacesList.isAutoConstruct()) {
                int networkInterfacesListIndex = 1;
                for (InstanceNetworkInterfaceSpecification networkInterfacesListValue : networkInterfacesList) {
                    SdkInternalList privateIpAddressesList;
                    Iterator groupsList;
                    if (networkInterfacesListValue.getNetworkInterfaceId() != null) {
                        request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex + ".NetworkInterfaceId", StringUtils.fromString((String)networkInterfacesListValue.getNetworkInterfaceId()));
                    }
                    if (networkInterfacesListValue.getDeviceIndex() != null) {
                        request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex + ".DeviceIndex", StringUtils.fromInteger((Integer)networkInterfacesListValue.getDeviceIndex()));
                    }
                    if (networkInterfacesListValue.getSubnetId() != null) {
                        request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex + ".SubnetId", StringUtils.fromString((String)networkInterfacesListValue.getSubnetId()));
                    }
                    if (networkInterfacesListValue.getDescription() != null) {
                        request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex + ".Description", StringUtils.fromString((String)networkInterfacesListValue.getDescription()));
                    }
                    if (networkInterfacesListValue.getPrivateIpAddress() != null) {
                        request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex + ".PrivateIpAddress", StringUtils.fromString((String)networkInterfacesListValue.getPrivateIpAddress()));
                    }
                    if (!(groupsList = (SdkInternalList)networkInterfacesListValue.getGroups()).isEmpty() || !groupsList.isAutoConstruct()) {
                        int groupsListIndex = 1;
                        Iterator iterator = groupsList.iterator();
                        while (iterator.hasNext()) {
                            String groupsListValue = (String)iterator.next();
                            if (groupsListValue != null) {
                                request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex + ".SecurityGroupId." + groupsListIndex, StringUtils.fromString((String)groupsListValue));
                            }
                            ++groupsListIndex;
                        }
                    }
                    if (networkInterfacesListValue.getDeleteOnTermination() != null) {
                        request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex + ".DeleteOnTermination", StringUtils.fromBoolean((Boolean)networkInterfacesListValue.getDeleteOnTermination()));
                    }
                    if (!(privateIpAddressesList = (SdkInternalList)networkInterfacesListValue.getPrivateIpAddresses()).isEmpty() || !privateIpAddressesList.isAutoConstruct()) {
                        int privateIpAddressesListIndex = 1;
                        for (PrivateIpAddressSpecification privateIpAddressesListValue : privateIpAddressesList) {
                            if (privateIpAddressesListValue.getPrivateIpAddress() != null) {
                                request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex + ".PrivateIpAddresses." + privateIpAddressesListIndex + ".PrivateIpAddress", StringUtils.fromString((String)privateIpAddressesListValue.getPrivateIpAddress()));
                            }
                            if (privateIpAddressesListValue.getPrimary() != null) {
                                request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex + ".PrivateIpAddresses." + privateIpAddressesListIndex + ".Primary", StringUtils.fromBoolean((Boolean)privateIpAddressesListValue.getPrimary()));
                            }
                            ++privateIpAddressesListIndex;
                        }
                    }
                    if (networkInterfacesListValue.getSecondaryPrivateIpAddressCount() != null) {
                        request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex + ".SecondaryPrivateIpAddressCount", StringUtils.fromInteger((Integer)networkInterfacesListValue.getSecondaryPrivateIpAddressCount()));
                    }
                    if (networkInterfacesListValue.getAssociatePublicIpAddress() != null) {
                        request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex + ".AssociatePublicIpAddress", StringUtils.fromBoolean((Boolean)networkInterfacesListValue.getAssociatePublicIpAddress()));
                    }
                    ++networkInterfacesListIndex;
                }
            }
            if ((iamInstanceProfile = launchSpecification.getIamInstanceProfile()) != null) {
                if (iamInstanceProfile.getArn() != null) {
                    request.addParameter("LaunchSpecification.IamInstanceProfile.Arn", StringUtils.fromString((String)iamInstanceProfile.getArn()));
                }
                if (iamInstanceProfile.getName() != null) {
                    request.addParameter("LaunchSpecification.IamInstanceProfile.Name", StringUtils.fromString((String)iamInstanceProfile.getName()));
                }
            }
            if (launchSpecification.getEbsOptimized() != null) {
                request.addParameter("LaunchSpecification.EbsOptimized", StringUtils.fromBoolean((Boolean)launchSpecification.getEbsOptimized()));
            }
            if (!(allSecurityGroupsList = (SdkInternalList)launchSpecification.getAllSecurityGroups()).isEmpty() || !allSecurityGroupsList.isAutoConstruct()) {
                int allSecurityGroupsListIndex = 1;
                for (GroupIdentifier allSecurityGroupsListValue : allSecurityGroupsList) {
                    if (allSecurityGroupsListValue.getGroupName() != null) {
                        request.addParameter("LaunchSpecification.GroupSet." + allSecurityGroupsListIndex + ".GroupName", StringUtils.fromString((String)allSecurityGroupsListValue.getGroupName()));
                    }
                    if (allSecurityGroupsListValue.getGroupId() != null) {
                        request.addParameter("LaunchSpecification.GroupSet." + allSecurityGroupsListIndex + ".GroupId", StringUtils.fromString((String)allSecurityGroupsListValue.getGroupId()));
                    }
                    ++allSecurityGroupsListIndex;
                }
            }
            if (launchSpecification.getMonitoringEnabled() != null) {
                request.addParameter("LaunchSpecification.Monitoring.Enabled", StringUtils.fromBoolean((Boolean)launchSpecification.getMonitoringEnabled()));
            }
            if (!(securityGroupsList = (SdkInternalList)launchSpecification.getSecurityGroups()).isEmpty() || !securityGroupsList.isAutoConstruct()) {
                int securityGroupsListIndex = 1;
                for (String securityGroupsListValue : securityGroupsList) {
                    if (securityGroupsListValue != null) {
                        request.addParameter("LaunchSpecification.SecurityGroup." + securityGroupsListIndex, StringUtils.fromString((String)securityGroupsListValue));
                    }
                    ++securityGroupsListIndex;
                }
            }
        }
        return request;
    }
}

